/**
 * Copyright (c) 2011-2014, hubin (jobob@qq.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.zbkj.service.huifu.constants;

/**
 * <b> 汇付支付业务接口标识 </b>
 * @author ZXF
 * @create 2023/08/02 0002 16:37
 * @version
 * @注意事项 </b>
 */
public enum HFBusiCode {
	JSQUERY("V2MerchantBasicdataSettlementQuery", "结算记录查询"),
	CWQUERY("V2TradeAcctpaymentAcctlogQuery", "账务流水查询"),
	JYFZQUERY("V2TradeTransSplitQuery", "交易分账明细查询接口（废弃）"),
	YEQUERY("V2TradeAcctpaymentBalanceQuery", "账户余额信息查询接口"),
	YEPAY("V2TradeAcctpaymentPay", "余额支付"),
	ZDCONFIG("V2MerchantBusiBillConfig", "交易结算对账单配置"),
	ZDREPLAY("V2TradeCheckReplay", "交易结算对账单重新生成"),
	ZDQUERY("V2TradeCheckFilequery", "交易结算对账单查询"),
	TXQUERY("V2TradeBatchtranslogQuery", "批量出金交易查询"),
	WYPAY("V2TradeOnlinepaymentBankingFrontpay", "网银支付接口"),
	HDQUERY("V2TradePaymentGetelectronicreceipt", "电子回单查询"),
	ENCHASHMENT("V2TradeSettlementEnchashment", "取现接口"),
	ENT("V2UserBasicdataEnt", "企业用户基本信息开户"),
	ENTMODIFY("V2UserBasicdataEntModify", "企业用户基本信息修改"),
	YHQUERY("V2UserBasicdataQuery", "用户信息查询"),
	BUSIMODIFY("V2UserBusiModify", "用户业务入驻修改"),
	BUSIOPEN("V2UserBusiOpen", "用户业务入驻"),
	JSPAY("V2TradePaymentJspay", "聚合正扫"),
	SCANPAYQUERY("V2TradePaymentScanpayQuery", "交易查询接口"),
	SCANPAYREFUND("V2TradePaymentScanpayRefund", "扫码交易退款"),
	REFUNDQUERY("V2TradePaymentScanpayRefundquery", "交易退款查询接口"),
	APQUERY("V2TradeAcctpaymentPayQuery", "余额支付查询");

	private final String cla;

	private final String desc;

	HFBusiCode(final String cla, final String desc) {
		this.cla = cla;
		this.desc = desc;
	}

	/**
	 * <p>
	 * 获取优化类型.如果没有找到默认null
	 * </p>
	 * 
	 * @param hFBusiCodeCla
	 *            优化方式
	 * @return
	 */
	public static HFBusiCode getHFBusiCodeCla(String hFBusiCodeCla) {
		for (HFBusiCode hFBusiCode : HFBusiCode.values()) {
			if (hFBusiCode.getCla().equalsIgnoreCase(hFBusiCodeCla)) {
				return hFBusiCode;
			}
		}
		return null;
	}

	public String getCla() {
		return this.cla;
	}

	public String getDesc() {
		return this.desc;
	}

}
