package com.zbkj.service.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.response.BcxSettleResponse;
import com.zbkj.common.response.BcxSettleStatisticsResponse;

import java.util.List;
import java.util.Map;

/**
 * description: 结算表 Mapper
 * author : linchunpeng
 * date : 2023/9/1
 */
public interface BcxSettleDao extends BaseMapper<BcxSettle> {

    /**
     * 查询渠道商结算单
     */
    List<BcxSettleResponse> selectChannelList(Map<String, Object> paramMap);

    /**
     * 查询部门结算单
     */
    List<BcxSettleResponse> selectDepartmentList(Map<String, Object> paramMap);

    /**
     * 查询部门成员结算单
     */
    List<BcxSettleResponse> selectDepartmentMemberList(Map<String, Object> paramMap);

    /**
     * 查询分销商结算单
     */
    List<BcxSettleResponse> selectFxsList(Map<String, Object> paramMap);

    /**
     * 查询分销员结算单
     */
    List<BcxSettleResponse> selectFxyList(Map<String, Object> paramMap);


    /**
     * 渠道商结算单统计
     */
    BcxSettleStatisticsResponse selectChannelCount(Map<String, Object> paramMap);

    /**
     * 部门结算单统计
     */
    BcxSettleStatisticsResponse selectDepartmentCount(Map<String, Object> paramMap);

    /**
     * 部门成员结算单统计
     */
    BcxSettleStatisticsResponse selectDepartmentMemberCount(Map<String, Object> paramMap);

    /**
     * 分销商结算单统计
     */
    BcxSettleStatisticsResponse selectFxsCount(Map<String, Object> paramMap);

    /**
     * 分销员结算单统计
     */
    BcxSettleStatisticsResponse selectFxyCount(Map<String, Object> paramMap);
   
}