/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.model.huifu.TaskResidual;
import com.zbkj.common.utils.SpringUtil;
import com.zbkj.service.dao.TaskResidualDao;
import com.zbkj.service.service.TaskResidualService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TaskResidualServiceImpl
extends ServiceImpl<TaskResidualDao, TaskResidual>
implements TaskResidualService {
    @Resource
    private TaskResidualDao dao;
    private Logger log = LoggerFactory.getLogger(TaskResidualServiceImpl.class);

    @Override
    public void disposeTaskResidualList(String isNightlyRun) {
        HashMap columnMap = Maps.newHashMap();
        if (StringUtils.isNotEmpty((CharSequence)isNightlyRun)) {
            columnMap.put("is_nightly_run", isNightlyRun);
        }
        List ctrList = this.dao.selectByMap(columnMap);
        for (TaskResidual ctr : ctrList) {
            try {
                Thread.sleep(300L);
                new Thread(() -> this.applyReturnBooleanOfClassReflect(ctr)).start();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void applyReturnBooleanOfClassReflect(TaskResidual ctr) {
        ClassLoader cls = Thread.currentThread().getContextClassLoader();
        String errEsg = "";
        try {
            Class<?> c = cls.loadClass(ctr.getClassName());
            String[] tArr = ctr.getParamTypeArr().split(",");
            String[] vArr = ctr.getParamValueArr().split(",", -1);
            Class[] csArr = new Class[ctr.getParamNum()];
            Object[] otArr = new Object[ctr.getParamNum()];
            for (int i = 0; i < ctr.getParamNum(); ++i) {
                String tp = tArr[i];
                if ("String".equals(tp)) {
                    csArr[i] = String.class;
                    otArr[i] = String.valueOf(vArr[i]);
                    continue;
                }
                if ("int".equals(tp)) {
                    csArr[i] = Integer.TYPE;
                    otArr[i] = Integer.parseInt(vArr[i]);
                    continue;
                }
                if ("BigDecimal".equals(tp)) {
                    csArr[i] = BigDecimal.class;
                    otArr[i] = new BigDecimal(vArr[i]);
                    continue;
                }
                if ("Long".equals(tp)) {
                    csArr[i] = Long.class;
                    otArr[i] = Long.parseLong(vArr[i]);
                    continue;
                }
                if ("com.zbkj.common.dto.HuifuWalletTransferDto".equals(tp)) {
                    csArr[i] = HuifuWalletTransferDto.class;
                    otArr[i] = JSONObject.parseObject((String)ctr.getParamValueArr(), Class.forName(ctr.getParamTypeArr()));
                    continue;
                }
                csArr[i] = Object.class;
                otArr[i] = JSONObject.parseObject((String)ctr.getParamValueArr(), Class.forName(ctr.getParamTypeArr()));
            }
            Object o = SpringUtil.getBean(c);
            Method method = o.getClass().getDeclaredMethod(ctr.getMethodName(), csArr);
            method.setAccessible(true);
            Object r = method.invoke(o, otArr);
            boolean ret = false;
            if (r != null && r.getClass().equals(Boolean.class)) {
                ret = (Boolean)r;
            } else if (r != null && r.getClass().equals(String.class)) {
                ret = true;
            }
            if (ret) {
                this.dao.deleteById(ctr.getId());
            } else {
                errEsg = "Apply Method Fail!!--------------------------";
            }
        }
        catch (ClassNotFoundException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalAccessException e) {
            errEsg = e.getMessage();
        }
        catch (NoSuchMethodException e) {
            errEsg = e.getMessage();
        }
        catch (SecurityException e) {
            errEsg = e.getMessage();
        }
        catch (IllegalArgumentException e) {
            errEsg = e.getMessage();
        }
        catch (InvocationTargetException e) {
            errEsg = e.getMessage();
        }
        if (StringUtils.isNotEmpty((CharSequence)errEsg)) {
            this.log.info("----------TaskResidual\u672a\u6210\u529f\u4efb\u52a1\u53cd\u5c04\u6267\u884c\uff08" + ctr.getAnnotation() + "\uff09,ExceptionMessage\uff1a" + errEsg);
        }
    }

    @Override
    public void saveTaskResidual(String methodName, String annotation, String className, int paramNum, String paramTypeArr, String paramValueArr) {
        LambdaQueryWrapper taskResidualQueryWrapper = new LambdaQueryWrapper();
        taskResidualQueryWrapper.eq(TaskResidual::getMethodName, (Object)methodName);
        taskResidualQueryWrapper.eq(TaskResidual::getParamValueArr, (Object)paramValueArr);
        List list = this.dao.selectList((Wrapper)taskResidualQueryWrapper);
        if (list.size() > 0) {
            System.out.println("=======> \u6253\u56de\u6253\u56de");
            return;
        }
        TaskResidual ctr = new TaskResidual(methodName, annotation, className, paramNum, paramTypeArr, paramValueArr, "0");
        new Thread(() -> {
            try {
                this.dao.insert(ctr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Override
    public void saveTaskResidual2(String methodName, String annotation, String className, int paramNum, String paramTypeArr, String paramValueArr) {
        TaskResidual ctr = new TaskResidual(methodName, annotation, className, paramNum, paramTypeArr, paramValueArr, "1");
        new Thread(() -> {
            try {
                this.dao.insert(ctr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static void main(String[] args) {
        TaskResidualServiceImpl c = new TaskResidualServiceImpl();
        TaskResidual ctr = (TaskResidual)c.dao.selectById(Integer.valueOf(1026392));
        c.applyReturnBooleanOfClassReflect(ctr);
    }
}

