/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.NotifyConstants;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.sms.SmsTemplate;
import com.zbkj.common.model.system.SystemNotification;
import com.zbkj.common.model.template.TemplateMessage;
import com.zbkj.common.request.NotificationInfoRequest;
import com.zbkj.common.request.NotificationSearchRequest;
import com.zbkj.common.request.NotificationUpdateRequest;
import com.zbkj.common.response.NotificationInfoResponse;
import com.zbkj.service.dao.SystemNotificationDao;
import com.zbkj.service.service.SmsTemplateService;
import com.zbkj.service.service.SystemNotificationService;
import com.zbkj.service.service.TemplateMessageService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemNotificationServiceImpl
extends ServiceImpl<SystemNotificationDao, SystemNotification>
implements SystemNotificationService {
    @Resource
    private SystemNotificationDao dao;
    @Autowired
    private TemplateMessageService templateMessageService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private TransactionTemplate transactionTemplate;

    @Override
    public List<SystemNotification> getList(NotificationSearchRequest request) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getSendType())) {
            lqw.eq(SystemNotification::getSendType, (Object)request.getSendType());
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean wechatSwitch(Integer id) {
        SystemNotification systemNotification = this.getByIdException(id);
        if (systemNotification.getIsWechat().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
            throw new CrmebException("\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u516c\u4f17\u53f7\u6a21\u677f");
        }
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(SystemNotification::getIsWechat, (Object)(systemNotification.getIsWechat().equals(NotifyConstants.SWITCH_OPEN) ? NotifyConstants.SWITCH_COLSE : NotifyConstants.SWITCH_OPEN));
        luw.eq(SystemNotification::getId, (Object)id);
        return this.update((Wrapper)luw);
    }

    @Override
    public Boolean routineSwitch(Integer id) {
        SystemNotification systemNotification = this.getByIdException(id);
        if (systemNotification.getIsRoutine().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
            throw new CrmebException("\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6a21\u677f");
        }
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(SystemNotification::getIsRoutine, (Object)(systemNotification.getIsRoutine().equals(NotifyConstants.SWITCH_OPEN) ? NotifyConstants.SWITCH_COLSE : NotifyConstants.SWITCH_OPEN));
        luw.eq(SystemNotification::getId, (Object)id);
        return this.update((Wrapper)luw);
    }

    @Override
    public Boolean smsSwitch(Integer id) {
        SystemNotification systemNotification = this.getByIdException(id);
        if (systemNotification.getIsSms().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
            throw new CrmebException("\u901a\u77e5\u6ca1\u6709\u914d\u7f6e\u77ed\u4fe1");
        }
        LambdaUpdateWrapper luw = Wrappers.lambdaUpdate();
        luw.set(SystemNotification::getIsSms, (Object)(systemNotification.getIsSms().equals(NotifyConstants.SWITCH_OPEN) ? NotifyConstants.SWITCH_COLSE : NotifyConstants.SWITCH_OPEN));
        luw.eq(SystemNotification::getId, (Object)id);
        return this.update((Wrapper)luw);
    }

    @Override
    public NotificationInfoResponse getDetail(NotificationInfoRequest request) {
        TemplateMessage templateMessage;
        SystemNotification notification = this.getByIdException(request.getId());
        NotificationInfoResponse response = new NotificationInfoResponse();
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_WECHAT)) {
            if (notification.getIsWechat().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
                throw new CrmebException("\u8bf7\u5148\u914d\u7f6e\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606f");
            }
            templateMessage = this.templateMessageService.infoException(notification.getWechatId());
            BeanUtils.copyProperties((Object)templateMessage, (Object)response);
            response.setStatus(notification.getIsWechat());
        }
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_ROUTINE)) {
            if (notification.getIsRoutine().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
                throw new CrmebException("\u8bf7\u5148\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6d88\u606f");
            }
            templateMessage = this.templateMessageService.infoException(notification.getRoutineId());
            BeanUtils.copyProperties((Object)templateMessage, (Object)response);
            response.setStatus(notification.getIsRoutine());
        }
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_SMS)) {
            if (notification.getIsSms().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
                throw new CrmebException("\u8bf7\u5148\u914d\u7f6e\u77ed\u4fe1\u6a21\u677f");
            }
            SmsTemplate smsTemplate = this.smsTemplateService.getDetail(notification.getSmsId());
            BeanUtils.copyProperties((Object)smsTemplate, (Object)response);
            response.setStatus(notification.getIsSms());
        }
        return response;
    }

    @Override
    public SystemNotification getByMark(String mark) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemNotification::getMark, (Object)mark);
        lqw.last(" limit 1");
        return (SystemNotification)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public List<SystemNotification> getListByWechat(String type) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if ("routine".equals(type)) {
            lqw.ne(SystemNotification::getIsRoutine, (Object)0);
        }
        if ("public".equals(type)) {
            lqw.ne(SystemNotification::getIsWechat, (Object)0);
        }
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean modify(NotificationUpdateRequest request) {
        if (!request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_SMS) && StrUtil.isBlank((CharSequence)request.getTempId())) {
            throw new CrmebException("\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemNotification notification = this.getByIdException(request.getId());
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_SMS) && !notification.getIsSms().equals(request.getStatus())) {
            notification.setIsSms(request.getStatus());
            return this.updateById(notification);
        }
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_WECHAT)) {
            if (notification.getIsWechat().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
                throw new CrmebException("\u8bf7\u5148\u4e3a\u901a\u77e5\u914d\u7f6e\u516c\u4f17\u53f7\u6a21\u677f");
            }
            TemplateMessage templateMessage = this.templateMessageService.infoException(notification.getWechatId());
            if (templateMessage.getTempId().equals(request.getTempId()) && notification.getIsWechat().equals(request.getStatus())) {
                return true;
            }
            return (Boolean)this.transactionTemplate.execute(e -> {
                if (!templateMessage.getTempId().equals(request.getTempId())) {
                    templateMessage.setTempId(request.getTempId());
                    this.templateMessageService.updateById(templateMessage);
                }
                if (!notification.getIsWechat().equals(request.getStatus())) {
                    notification.setIsWechat(request.getStatus());
                    this.updateById(notification);
                }
                return Boolean.TRUE;
            });
        }
        if (request.getDetailType().equals(NotifyConstants.DETAIL_TYPE_ROUTINE)) {
            if (notification.getIsRoutine().equals(NotifyConstants.SWITCH_NOT_EXIST)) {
                throw new CrmebException("\u8bf7\u5148\u4e3a\u901a\u77e5\u914d\u7f6e\u5c0f\u7a0b\u5e8f\u8ba2\u9605\u6a21\u677f");
            }
            TemplateMessage templateMessage = this.templateMessageService.infoException(notification.getRoutineId());
            if (templateMessage.getTempId().equals(request.getTempId()) && notification.getIsRoutine().equals(request.getStatus())) {
                return true;
            }
            return (Boolean)this.transactionTemplate.execute(e -> {
                if (!templateMessage.getTempId().equals(request.getTempId())) {
                    templateMessage.setTempId(request.getTempId());
                    this.templateMessageService.updateById(templateMessage);
                }
                if (!notification.getIsRoutine().equals(request.getStatus())) {
                    notification.setIsRoutine(request.getStatus());
                    this.updateById(notification);
                }
                return Boolean.TRUE;
            });
        }
        return true;
    }

    @Override
    public List<TemplateMessage> getMiniTempList(String type) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(SystemNotification::getIsRoutine, (Object)1);
        switch (type) {
            case "beforePay": {
                lqw.eq(SystemNotification::getMark, (Object)"paySuccess");
                break;
            }
            case "afterPay": {
                lqw.in(SystemNotification::getMark, new Object[]{"deliverGoods", "fulfillmentOrder", "receiptGoods"});
                break;
            }
            case "refundApply": {
                lqw.eq(SystemNotification::getMark, (Object)"-1");
                break;
            }
            case "beforeRecharge": {
                lqw.eq(SystemNotification::getMark, (Object)"-1");
                break;
            }
            case "createBargain": {
                lqw.in(SystemNotification::getMark, new Object[]{"bargainingSuccess"});
                break;
            }
            case "pink": {
                lqw.in(SystemNotification::getMark, new Object[]{"groupSuccess"});
                break;
            }
            case "cancelPink": {
                lqw.eq(SystemNotification::getMark, (Object)"-1");
            }
        }
        List list = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)list)) {
            return CollUtil.newArrayList((Object[])new TemplateMessage[0]);
        }
        List<Integer> tidList = list.stream().map(SystemNotification::getRoutineId).collect(Collectors.toList());
        return this.templateMessageService.getByIdList(tidList);
    }

    private SystemNotification getByIdException(Integer id) {
        SystemNotification notification = (SystemNotification)this.getById(id);
        if (ObjectUtil.isNull((Object)notification)) {
            throw new CrmebException("\u7cfb\u7edf\u901a\u77e5\u4e0d\u5b58\u5728");
        }
        return notification;
    }
}

