/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import java.util.HashMap;
import java.util.Map;

public class UrlUtil {
    public static UrlEntity parse(String url) {
        UrlEntity entity = new UrlEntity();
        if (url == null) {
            return entity;
        }
        if ((url = url.trim()).equals("")) {
            return entity;
        }
        String[] urlParts = url.split("\\?");
        entity.baseUrl = urlParts[0];
        if (urlParts.length == 1) {
            return entity;
        }
        String[] params = urlParts[1].split("&");
        entity.params = new HashMap<String, String>();
        for (String param : params) {
            String[] keyValue = param.split("=");
            if (keyValue.length <= 1) continue;
            entity.params.put(keyValue[0], keyValue[1]);
        }
        return entity;
    }

    public static String getParamsByKey(String url, String key) {
        UrlEntity entity = UrlUtil.parse(url);
        return entity.params.get(key);
    }

    public static void main(String[] args) {
        UrlEntity entity = UrlUtil.parse(null);
        entity = UrlUtil.parse("http://www.123.com?id=1&name=\u5c0f\u660e");
        System.out.println(entity.baseUrl + "\n" + entity.params);
        System.out.println(entity.params.get("id"));
    }

    public static class UrlEntity {
        public String baseUrl;
        public Map<String, String> params;
    }
}

