/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.user.UserTag;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserTagRequest;
import com.zbkj.service.dao.UserTagDao;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.UserTagService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserTagServiceImpl
extends ServiceImpl<UserTagDao, UserTag>
implements UserTagService {
    @Resource
    private UserTagDao dao;
    @Autowired
    private UserService userService;

    @Override
    public PageInfo<UserTag> getList(PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(UserTag::getId);
        List tagList = this.dao.selectList((Wrapper)lqw);
        return CommonPage.copyPageInfo((Page)page, (List)tagList);
    }

    @Override
    public Boolean create(UserTagRequest userTagRequest) {
        UserTag userTag = new UserTag();
        BeanUtils.copyProperties((Object)userTagRequest, (Object)userTag);
        userTag.setId(null);
        return this.save(userTag);
    }

    @Override
    public Boolean delete(Integer id) {
        UserTag userTag = (UserTag)this.getById(id);
        if (ObjectUtil.isNull((Object)userTag)) {
            return Boolean.TRUE;
        }
        if (this.userService.isUsedTag(id).booleanValue()) {
            throw new CrmebException("\u7528\u6237\u4f7f\u7528\u6b64\u6807\u7b7e\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return this.removeById(id);
    }

    @Override
    public Boolean updateTag(UserTagRequest userTagRequest) {
        if (ObjectUtil.isNull((Object)userTagRequest.getId())) {
            throw new CrmebException("ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UserTag userTag = (UserTag)this.getById(userTagRequest.getId());
        userTag.setName(userTagRequest.getName());
        return this.updateById(userTag);
    }

    @Override
    public List<UserTag> getAllList() {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.orderByDesc(UserTag::getId);
        return this.dao.selectList((Wrapper)lqw);
    }
}

