/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.express.ShippingTemplates;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ShippingTemplatesRequest;
import com.zbkj.common.request.ShippingTemplatesSearchRequest;
import com.zbkj.common.response.ShippingTemplatesFreeResponse;
import com.zbkj.common.response.ShippingTemplatesInfoResponse;
import com.zbkj.common.response.ShippingTemplatesRegionResponse;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.LoginUserVo;
import com.zbkj.service.dao.ShippingTemplatesDao;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.ShippingTemplatesFreeService;
import com.zbkj.service.service.ShippingTemplatesRegionService;
import com.zbkj.service.service.ShippingTemplatesService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ShippingTemplatesServiceImpl
extends ServiceImpl<ShippingTemplatesDao, ShippingTemplates>
implements ShippingTemplatesService {
    @Resource
    private ShippingTemplatesDao dao;
    @Autowired
    private ShippingTemplatesRegionService shippingTemplatesRegionService;
    @Autowired
    private ShippingTemplatesFreeService shippingTemplatesFreeService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private ProductService productService;

    @Override
    public List<ShippingTemplates> getList(ShippingTemplatesSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (admin.getMerId() > 0) {
            lqw.eq(ShippingTemplates::getMerId, (Object)admin.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getKeywords())) {
            String keywords = URLUtil.decode((String)request.getKeywords());
            lqw.like(ShippingTemplates::getName, (Object)keywords);
        }
        ((LambdaQueryWrapper)lqw.orderByDesc(ShippingTemplates::getSort)).orderByDesc(ShippingTemplates::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean create(ShippingTemplatesRequest request) {
        if (this.isExistName(request.getName()).booleanValue()) {
            throw new CrmebException("\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u66f4\u6362\u6a21\u677f\u540d\u79f0!");
        }
        List shippingTemplatesRegionRequestList = request.getShippingTemplatesRegionRequestList();
        if (request.getAppoint().equals(2) && CollUtil.isEmpty((Collection)shippingTemplatesRegionRequestList)) {
            throw new CrmebException("\u4e0d\u5305\u90ae\uff0c\u6700\u5c11\u9700\u8981\u4e00\u6761\u516c\u5171\u533a\u57df\u8fd0\u8d39\u6570\u636e");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        ShippingTemplates shippingTemplates = new ShippingTemplates();
        shippingTemplates.setName(request.getName());
        shippingTemplates.setSort(request.getSort());
        shippingTemplates.setType(request.getType());
        shippingTemplates.setAppoint(request.getAppoint());
        shippingTemplates.setMerId(loginUserVo.getUser().getMerId());
        shippingTemplates.setId(null);
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean save = this.save(shippingTemplates);
            if (!save) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (!shippingTemplates.getAppoint().equals(0) && CollUtil.isNotEmpty((Collection)shippingTemplatesRegionRequestList) && !(save = this.shippingTemplatesRegionService.saveAll(shippingTemplatesRegionRequestList, shippingTemplates.getType(), shippingTemplates.getId()).booleanValue())) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (shippingTemplates.getAppoint().equals(2) && CollUtil.isNotEmpty((Collection)request.getShippingTemplatesFreeRequestList()) && !(save = this.shippingTemplatesFreeService.saveAll(request.getShippingTemplatesFreeRequestList(), shippingTemplates.getType(), shippingTemplates.getId()).booleanValue())) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    private ShippingTemplates getByName(String name) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(ShippingTemplates::getName, (Object)name);
        return (ShippingTemplates)this.dao.selectOne((Wrapper)lqw);
    }

    private Boolean isExistName(String name) {
        ShippingTemplates templates = this.getByName(name);
        if (ObjectUtil.isNull((Object)templates)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean edit(ShippingTemplatesRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u8fd0\u8d39\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ShippingTemplates shippingTemplates = this.getByIdException(request.getId());
        List shippingTemplatesRegionRequestList = request.getShippingTemplatesRegionRequestList();
        if (request.getAppoint().equals(2) && CollUtil.isEmpty((Collection)shippingTemplatesRegionRequestList)) {
            throw new CrmebException("\u4e0d\u5305\u90ae\uff0c\u6700\u5c11\u9700\u8981\u4e00\u6761\u516c\u5171\u533a\u57df\u8fd0\u8d39\u6570\u636e");
        }
        if (!shippingTemplates.getName().equals(request.getName()) && this.isExistName(request.getName()).booleanValue()) {
            throw new CrmebException("\u6a21\u677f\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u66f4\u6362\u6a21\u677f\u540d\u79f0!");
        }
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        if (!loginUserVo.getUser().getMerId().equals(shippingTemplates.getMerId())) {
            throw new CrmebException("\u4e0d\u80fd\u64cd\u4f5c\u975e\u672c\u5546\u6237\u7684\u6570\u636e");
        }
        shippingTemplates.setName(request.getName());
        shippingTemplates.setSort(request.getSort());
        shippingTemplates.setType(request.getType());
        return (Boolean)this.transactionTemplate.execute(e -> {
            if (!shippingTemplates.getAppoint().equals(0)) {
                this.shippingTemplatesRegionService.deleteByTempId(shippingTemplates.getId());
            }
            if (shippingTemplates.getAppoint().equals(2)) {
                this.shippingTemplatesFreeService.deleteByTempId(shippingTemplates.getId());
            }
            shippingTemplates.setAppoint(request.getAppoint());
            boolean update = this.updateById(shippingTemplates);
            if (!update) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (CollUtil.isNotEmpty((Collection)shippingTemplatesRegionRequestList) && !(update = this.shippingTemplatesRegionService.saveAll(shippingTemplatesRegionRequestList, request.getType(), shippingTemplates.getId()).booleanValue())) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            if (shippingTemplates.getAppoint().equals(2) && CollUtil.isNotEmpty((Collection)request.getShippingTemplatesFreeRequestList()) && !(update = this.shippingTemplatesFreeService.saveAll(request.getShippingTemplatesFreeRequestList(), request.getType(), shippingTemplates.getId()).booleanValue())) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean remove(Integer id) {
        ShippingTemplates shippingTemplates = this.getByIdException(id);
        LoginUserVo loginUserVo = SecurityUtil.getLoginUserVo();
        if (!loginUserVo.getUser().getMerId().equals(shippingTemplates.getMerId())) {
            throw new CrmebException("\u4e0d\u80fd\u64cd\u4f5c\u975e\u672c\u5546\u6237\u7684\u6570\u636e");
        }
        if (this.productService.isUseShippingTemplateId(id).booleanValue()) {
            throw new CrmebException("\u6709\u5546\u54c1\u4f7f\u7528\u6b64\u8fd0\u8d39\u6a21\u677f\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.shippingTemplatesRegionService.deleteByTempId(id);
            this.shippingTemplatesFreeService.deleteByTempId(id);
            this.removeById(id);
            return Boolean.TRUE;
        });
    }

    @Override
    public ShippingTemplatesInfoResponse getInfo(Integer id) {
        ShippingTemplates shippingTemplates = this.getByIdException(id);
        ShippingTemplatesInfoResponse response = new ShippingTemplatesInfoResponse();
        BeanUtils.copyProperties((Object)shippingTemplates, (Object)response);
        if (shippingTemplates.getAppoint().equals(0)) {
            return response;
        }
        List<ShippingTemplatesRegionResponse> regionResponseList = this.shippingTemplatesRegionService.getListGroup(id);
        if (CollUtil.isNotEmpty(regionResponseList)) {
            for (int i = 0; i < regionResponseList.size(); ++i) {
                ShippingTemplatesRegionResponse regionResponse = regionResponseList.get(i);
                regionResponse.setTitle("[" + regionResponse.getTitle() + "]");
                if (!regionResponse.getTitle().equals("[[0,0]]") || i <= 0) continue;
                regionResponseList.remove(i);
                regionResponseList.add(0, regionResponse);
            }
            response.setRegionList(regionResponseList);
        }
        if (shippingTemplates.getAppoint().equals(2)) {
            List<ShippingTemplatesFreeResponse> freeResponseList = this.shippingTemplatesFreeService.getListGroup(id);
            freeResponseList.forEach(freeResponse -> freeResponse.setTitle("[" + freeResponse.getTitle() + "]"));
            response.setFreeList(freeResponseList);
        }
        return response;
    }

    private ShippingTemplates getByIdException(Integer id) {
        ShippingTemplates shippingTemplates = (ShippingTemplates)this.getById(id);
        if (ObjectUtil.isNull((Object)shippingTemplates)) {
            throw new CrmebException("\u8fd0\u8d39\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        return shippingTemplates;
    }
}

