package com.zbkj.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 一号通用户短信详情对象
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "OnePassUserSmsVo对象", description = "一号通用户短信详情对象")
public class OnePassUserSmsVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "可用条数")
    private Integer num;

    @ApiModelProperty(value = "总量")
    private Integer surp;

    @ApiModelProperty(value = "签名")
    private String sign;

    @ApiModelProperty(value = "签名状态")
    private Integer sign_status;

    @ApiModelProperty(value = "是否开启，1-开启")
    private Integer open;
}
