package com.zbkj.common.response.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentStyle;
import com.alibaba.excel.enums.poi.HorizontalAlignmentEnum;
import com.alibaba.excel.enums.poi.VerticalAlignmentEnum;
import com.zbkj.common.enums.BcxReportSettleStatusEnum;
import com.zbkj.common.utils.DateConverter;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 业绩报表-基础导出excel dto对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
public class BcxPerformanceReportBaseExcelDto {

    @ExcelProperty(value = "订单号", order = 1)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String orderNo;

    @ExcelProperty(value = "订单时间", converter = DateConverter.class, order = 2)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private Date orderTime;

    @ExcelProperty(value = "商品名称", order = 3)
    @ColumnWidth(20)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String productName;

    @ExcelProperty(value = "成交金额", order = 4)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal payPrice;

    @ExcelProperty(value = "佣金", order = 5)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal brokeragePrice;

    @ExcelIgnore
    private Integer brokerageConfigType;
    @ExcelProperty(value = "佣金类型", order = 97)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String brokerageConfigTypeName;

    @ExcelProperty(value = "分佣规则", order = 98)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private BigDecimal brokerageRatio;

    @ExcelProperty(value = "客户（购买人）", order = 99)
    @ColumnWidth(30)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String orderUserRealName;

    @ExcelIgnore
    private Integer settleStatus;
    @ExcelProperty(value = "结算状态", order = 100)
    @ColumnWidth(15)
    @ContentStyle(horizontalAlignment = HorizontalAlignmentEnum.CENTER, verticalAlignment = VerticalAlignmentEnum.CENTER)
    private String settleStatusName;

    public String getBrokerageConfigTypeName() {
        if (brokerageConfigType != null) {
            return brokerageConfigType == 1 ? "默认比例" : "自定义比例";
        }
        return null;
    }

    public String getSettleStatusName() {
        if (settleStatus != null) {
            return BcxReportSettleStatusEnum.getInstance(settleStatus).getName();
        }
        return null;
    }
}