package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

@Data
@Builder
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="LoginOrgResponse", description="用户登录组织域返回数据")
public class LoginOrgResponse implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "用户登陆组织域id")
    private Integer loginOrgId;
    @ApiModelProperty(value = "用户账号")
    private String account;
    @ApiModelProperty(value = "组织名称")
    private String orgName;
}
