package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * description：用户绑定银行卡表
 * author：linchunpeng
 * date：2023/11/1
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_user_bank")
@ApiModel(value = "BcxUserBank对象", description = "用户绑定银行卡表")
public class BcxUserBank implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "用户id")
    private Integer uid;
    
    @ApiModelProperty(value = "姓名")
    private String userName;

    @ApiModelProperty(value = "银行编号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long bankCode;

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "支行联行编号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long branchCode;

    @ApiModelProperty(value = "支行名称")
    private String branchName;

    @ApiModelProperty(value = "银行卡号")
    private String bankCardNo;

    @ApiModelProperty(value = "是否默认银行卡：0否，1是")
    private Integer isDefault;

    @ApiModelProperty(value = "状态：0无效，1有效")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    
}