package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票申请单
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_fapiao_apply")
@ApiModel(value = "BcxFapiaoApply对象", description = "发票申请单")
public class BcxFapiaoApply implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    @ApiModelProperty(value = "申请时间")
    private Date applyTime;

    @ApiModelProperty(value = "开票方id")
    private Integer writerId;

    @ApiModelProperty(value = "开票方")
    private String writer;

    @ApiModelProperty(value = "开票时间")
    private Date writeTime;

    @ApiModelProperty(value = "收票方id")
    private Integer receiverId;

    @ApiModelProperty(value = "收票方")
    private String receiver;

    @ApiModelProperty(value = "费用类型：0-商品购买 1-平台服务费 2-渠道服务费 3-分销服务费")
    private Integer sourceType;

    @ApiModelProperty(value = "发票号")
    private String fapiaoNo;

    @ApiModelProperty(value = "状态 0-未开票 1-已开票 2-开票中 3-开票失败")
    private Integer fapiaoStatus;

    @ApiModelProperty(value = "0-个人 1-企业")
    private Integer titleType;

    @ApiModelProperty(value = "0-增值税普通 1-增值税专用")
    private Integer fapiaoType;

    @ApiModelProperty(value = "发票抬头")
    private String title;

    @ApiModelProperty(value = "发票金额")
    private BigDecimal fapiaoAmount;

    @ApiModelProperty(value = "税号")
    private String taxNo;

    @ApiModelProperty(value = "开户银行")
    private String bankName;

    @ApiModelProperty(value = "银行账号")
    private String bankAccount;

    @ApiModelProperty(value = "企业地址")
    private String address;

    @ApiModelProperty(value = "企业电话")
    private String phone;

    @ApiModelProperty(value = "收票人名称")
    private String sendToName;

    @ApiModelProperty(value = "收票人电话")
    private String sendToPhone;

    @ApiModelProperty(value = "收票人email")
    private String sendToEmail;

    @ApiModelProperty(value = "收票人地址")
    private String sendToAddress;
    
    @ApiModelProperty(value = "拒绝原因")
    private String rejectReason;

    @ApiModelProperty(value = "销方识别号")
    private String vendorId;

    @ApiModelProperty(value = "销方名称")
    private String vendorName;

    @ApiModelProperty(value = "发票来源")
    private String fapiaoOrg;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
