package com.zbkj.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <b> 确认支付参数 </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuCheckTransferDto", description="确认支付参数")
public class HuifuCheckTransferDto implements Serializable {

    @ApiModelProperty(value = "账户状态")
    private String accountStatus;
    @ApiModelProperty(value = "订单金额")
    private String amount;
    @ApiModelProperty(value = "订单ID")
    private String orderId;
    @ApiModelProperty(value = "备注")
    private String comment;
    @ApiModelProperty(value = "出账方")
    private String outId;

    @ApiModelProperty(value = "入账方")
    private String inId;
    @ApiModelProperty(value = "入账方名称")
    private String inName;
    @ApiModelProperty(value = "入账方账户号")
    private String inWalletAccountNo;
    @ApiModelProperty(value = "入账方银行卡号")
    private String inBankCardNo;
}
