/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.enums;

import com.zbkj.common.utils.CrmebUtil;

public enum BizEnum {
    PHY("\u666e\u901a\u5546\u54c1", 0),
    SIR("\u865a\u62df\u5546\u54c1", 1),
    SPA("\u7279\u6b8a\u5546\u54c1", 2),
    INS("\u4fdd\u9669\u5546\u54c1", 3),
    RIS("\u98ce\u8bc4\u5546\u54c1", 4);

    private final String name;
    private final Integer value;

    private BizEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        return this.value;
    }

    public static String beforeRule(Integer value) {
        for (BizEnum biz : BizEnum.values()) {
            if (!biz.value.equals(value)) continue;
            return biz.toString();
        }
        return "PT";
    }

    public static String lastRule(Integer value) {
        return "S" + (value < 10 ? "0" : "") + value;
    }

    public static String buildNoPrefix(String orderNo, Integer bizType) {
        boolean isPrefix = false;
        for (BizEnum biz : BizEnum.values()) {
            if (!orderNo.startsWith(biz.toString())) continue;
            isPrefix = true;
            break;
        }
        if (!isPrefix) {
            orderNo = CrmebUtil.getOrderNo(BizEnum.beforeRule(bizType));
        }
        return orderNo;
    }
}

