/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.utils.UploadUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(ExportUtil.class);

    public static String exportExcel(String fileName, String title, List<?> voList, LinkedHashMap<String, String> aliasMap) {
        if (StrUtil.isBlank((CharSequence)fileName)) {
            throw new CrmebException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StrUtil.isBlank((CharSequence)title)) {
            throw new CrmebException("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(voList)) {
            throw new CrmebException("\u6570\u636e\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollUtil.isEmpty(aliasMap)) {
            throw new CrmebException("\u522b\u540dmap\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String hzwServerPath = UploadUtil.getHzwServerPath();
        String filePath = StrUtil.format((CharSequence)"{}/{}/{}/{}/", (Object[])new Object[]{"crmebimage", "downloadf", "excel", CrmebDateUtil.nowDate("yyyy-MM-dd").replace("-", "/")});
        String path = FilenameUtils.separatorsToSystem((String)(hzwServerPath + filePath));
        String newFileName = filePath + fileName;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        fileName = path.concat(fileName);
        ExcelWriter writer = ExcelUtil.getWriter((String)fileName);
        CellStyle headCellStyle = writer.getHeadCellStyle();
        Font font = writer.createFont();
        font.setBold(true);
        headCellStyle.setFont(font);
        CellStyle styleSet = writer.getCellStyle();
        styleSet.setWrapText(true);
        aliasMap.forEach((key, value) -> writer.addHeaderAlias(key, value));
        writer.merge(aliasMap.size() - 1, (Object)title);
        writer.merge(aliasMap.size() - 1, (Object)StrUtil.format((CharSequence)"\u751f\u6210\u65f6\u95f4:{}", (Object[])new Object[]{DateUtil.now()}));
        writer.setColumnWidth(-1, 22);
        writer.write(voList, true);
        writer.close();
        return newFileName;
    }

    public static void setUpload(String rootPath, String modelPath, String type) {
        if (StrUtil.isBlank((CharSequence)rootPath) || StrUtil.isBlank((CharSequence)modelPath) || StrUtil.isBlank((CharSequence)type)) {
            throw new CrmebException("\u8bf7\u68c0\u67e5\u4e0a\u4f20\u53c2\u6570\uff0c\u4e0a\u4f20\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UploadUtil.setRootPath(rootPath);
        UploadUtil.setModelPath("crmebimage/uploadf/" + modelPath);
    }

    public void export(String fileName, List<T> resultList, HttpServletResponse response) {
        try {
            this.setExcelResponse(fileName, response);
            if (CollectionUtil.isNotEmpty(resultList)) {
                ((ExcelWriterSheetBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), resultList.get(0).getClass()).autoCloseStream(Boolean.valueOf(false)).excelType(ExcelTypeEnum.XLS).sheet(fileName).registerWriteHandler((WriteHandler)this.getWriteCellStyle())).doWrite(resultList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("[\u5bfc\u51faexcel-{}]\u5f02\u5e38\uff0c{}", new Object[]{fileName, e.getMessage(), e});
        }
    }

    private void setExcelResponse(String name, HttpServletResponse response) throws UnsupportedEncodingException {
        String fileName = String.format("%s-%s", name, DateUtils.getDate("yyyyMMddHHmmss"));
        String disposition = String.format("attachment;filename=%s.xls", URLEncoder.encode(fileName, "UTF-8"));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Content-Disposition", disposition);
        response.setContentType("application/vnd.ms-excel;charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Method", "POST,GET,OPTIONS");
        response.setHeader("Access-Control-Allow-Headers", "*");
    }

    private HorizontalCellStyleStrategy getWriteCellStyle() {
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}

