/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2014-2016 abel533@gmail.com
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package tk.mybatis.springboot.service;


import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tk.mybatis.springboot.mapper.SmsRecordMapper;
import tk.mybatis.springboot.model.SmsRecord;
import tk.mybatis.springboot.util.*;

import javax.annotation.Resource;
import java.io.*;
import java.net.*;
import java.util.List;
import java.util.Map;


@Service
public class SmsRecordService {

    @Resource
    private SmsRecordMapper smsRecordMapper;

    @Resource
    private EmailUtil emailUtil;

    private static IdWorker idWorker = new IdWorker();

    public SmsRecord getById(Integer id) {
        return smsRecordMapper.selectByPrimaryKey(id);
    }

	public void selectReset() {
		List<SmsRecord> list = smsRecordMapper.selectReset();
		int i=0;
		for (SmsRecord smsRecord :list) {
			if(i==50){
				i=0;
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
			new Thread(()->{
				System.out.println("============>selectReset id:"+smsRecord.getId());
				sendSMS(smsRecord);
			}).start();
			i++;
		}
	}

	public List<SmsRecord> selectByMobile(String mobile) {
		List<SmsRecord> list = smsRecordMapper.selectByMobile(mobile);
		for (SmsRecord smsRecord :list) {
			smsRecord.setSendDate(DateUtil.formatDateTime(smsRecord.getCreate_date()));
		}
		return list;
	}

    public void save(SmsRecord smsRecord) {
        smsRecordMapper.insert(smsRecord);
    }

	public void sendSMS(SmsRecord smsRecord) {
		String url="http://www.api.zthysms.com/sendSms.do";
		//String username="baichuanxinhy"; //账e号，百川信网络服务公司账号，2021.1.28 还剩5万条
		//String password="S9F3Qx";  //密码
		String username="baichuanxin66hy";  //账e号，百川信人力资源账号
		String password="TxE45Eqe";  //密码
		String tkey=TimeUtil.getNowTime("yyyyMMddHHmmss");
		String mobile=smsRecord.getMobile();  //发送的手机号
		String content=smsRecord.getContent();   //内容

		//String time="2016-09-06 17:48:22";//定时信息所需参数时间格式为yyyy-MM-dd HH:mm:ss
		String xh="";
		try {
			content = URLEncoder.encode(content, "utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		String param = "url="+url+"&username="+username+"&password="+MD5Gen.getMD5(MD5Gen.getMD5(password)+tkey)+"&tkey="+tkey+"&mobile="+mobile+"&content="+content+"&xh="+xh;
		String ret=HttpRequest.sendPost(url,param);//定时信息只可为post方式提交
		String[] rets=ret.split(",");
		//smsRecord.setUrl(param);
		smsRecord.setRet(rets[0]);
		//smsRecord.setMsgid(rets[1]);
		smsRecordMapper.updateByPrimaryKey(smsRecord);
	}

	public void sendZhuTongSMS(SmsRecord smsRecord) {
		String url="https://hy.mix2.zthysms.com/sendSms.do";
		//String username="baichuanxinhy"; //账e号，百川信网络服务公司账号，2021.1.28 还剩5万条
		//String password="S9F3Qx";  //密码
		String username="baichuanxin66hy";  //账e号，百川信人力资源账号
		String password="TxE45Eqe";  //密码
		String tkey=TimeUtil.getNowTime("yyyyMMddHHmmss");
		String mobile=smsRecord.getMobile();  //发送的手机号
		String content=smsRecord.getContent();   //内容

		System.out.println("============>sendZhuTongSMS star");
		String xh="";
		try {
			content = URLEncoder.encode(content, "utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		String param = "url="+url+"&username="+username+"&password="+MD5Gen.getMD5(MD5Gen.getMD5(password)+tkey)+"&tkey="+tkey+"&mobile="+mobile+"&content="+content+"&xh="+xh;
		System.out.println("============>sendZhuTongSMS param:"+param);
		String ret = HttpRequest.sendPost(url,param);//定时信息只可为post方式提交
		System.out.println("============>sendZhuTongSMS ret:"+ret);
		String[] rets = ret.split(",");
		smsRecord.setRet(rets[0]);
		if ("1".equals(smsRecord.getRet())) {
			smsRecord.setSuccess(1);
		} else {
			smsRecord.setSuccess(0);
		}
		smsRecord.setChannel("zhutong");
		smsRecordMapper.insert(smsRecord);
		System.out.println("============>sendZhuTongSMS end");
	}

	public boolean sendBeijingSMS(SmsRecord smsRecord) {
		smsRecord.setChannel("beijing");
		String url = ConfigUtil.getValue("sms_beijing_url");
		List<NameValuePair> params = Lists.newArrayList();
		params.add(new BasicNameValuePair("phonenumber", smsRecord.getMobile()));
		params.add(new BasicNameValuePair("content", smsRecord.getContent()));
		boolean bool = true;
		smsRecord.setSuccess(1);
		try {
			String responseStr = BcxinHttpUtil.sendPostRequest(url, params);
			Map<String, Object> responseMap = JSON.parseObject(responseStr, Map.class);
			smsRecord.setRet(responseMap.get("code").toString());
			if (!"0".equals(smsRecord.getRet())) {
				emailUtil.sendEmail("北京短信通道返回异常", responseStr, ConfigUtil.getValue("osp_email"));
				smsRecord.setSuccess(0);
				bool = false;
			}
		} catch (Exception e){
			emailUtil.sendEmail("北京短信通道连接异常", e.getMessage(), ConfigUtil.getValue("osp_email"));
			smsRecord.setSuccess(0);
			bool = false;
		}
		smsRecordMapper.insert(smsRecord);
		return bool;
	}

	public void sendWeiLaiSMS(SmsRecord smsRecord) {
		// 发送短信地址，以下为示例地址，具体地址询问网关获取
		String url_send_sms = "https://smsapp.wlwx.com/sendSms";
		// 用户账号，必填
		String cust_code = "560643";
		// 用户密码，必填
		String cust_pwd = "YVID8791XS";
		// 短信内容，必填
		String content = "【百川信】"+smsRecord.getContent();
		// 接收号码，必填，同时发送给多个号码时,号码之间用英文半角逗号分隔
		String destMobiles = smsRecord.getMobile();
		// 业务标识，选填，由客户自行填写不超过20位的数字
		String uid = String.valueOf(idWorker.nextId());
		// 长号码，选填
		String sp_code = "";
		// 是否需要状态报告
		String need_report = "yes";
		// 数字签名，签名内容根据 “短信内容+客户密码”进行MD5编码后获得
		String sign = content + cust_pwd;
		System.out.println("send api:\t"+url_send_sms);
		sign = MD5Util.getMD5(sign,"UTF-8");
		String json_send_sms = "{\"cust_code\":\"" + cust_code + "\",\"content\":\"" + content +
				"\",\"destMobiles\":\"" + destMobiles + "\",\"uid\":\"" + uid + "\",\"need_report\":\"" + need_report + "\",\"sign\":\"" + sign + "\"}";
		System.out.println("send msg:\t"+json_send_sms);
		String ret = HttpRequest.sendPost(url_send_sms,json_send_sms);
		System.out.println("recv msg:\t"+ret);
		smsRecord.setRet(ret);
		if(StringUtils.isEmpty(ret)){
			smsRecord.setSuccess(0);
		}
		JSONObject j = JSON.parseObject(ret);
		if("0".equals(String.valueOf(j.get("respCode")))){
			smsRecord.setSuccess(1);
		}else{
			smsRecord.setSuccess(0);
		}
		smsRecord.setChannel("weilai");
		smsRecordMapper.insert(smsRecord);
	}

	public static void main(String[] args) {
		SmsRecord smsRecord = new SmsRecord();
		smsRecord.setMobile("18965192886");
		smsRecord.setContent("【未来无线】您好，您的验证码为138695，五分钟内有效");
		smsRecord.setPlatform("SAAS");
//		sendWeiLaiSMS(smsRecord);
		//String url="https://hy.mix2.zthysms.com/sendSms.do";
		String url="http://www.api.zthysms.com/sendSms.do";
		//String username="baichuanxinhy"; //账e号，百川信网络服务公司账号，2021.1.28 还剩5万条
		//String password="S9F3Qx";  //密码
		String username="baichuanxin66hy";  //账e号，百川信人力资源账号
		String password="TxE45Eqe";  //密码
		String tkey=TimeUtil.getNowTime("yyyyMMddHHmmss");
		String mobile=smsRecord.getMobile();  //发送的手机号
		String content=smsRecord.getContent();   //内容

		String xh="";
		try {
			content = URLEncoder.encode(content, "utf-8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		String param = "url="+url+"&username="+username+"&password="+MD5Gen.getMD5(MD5Gen.getMD5(password)+tkey)+"&tkey="+tkey+"&mobile="+mobile+"&content="+content+"&xh="+xh;
		String ret=HttpRequest.sendPost(url,param);//定时信息只可为post方式提交
		System.out.println("返回"+ret);
	}


}
