package com.bcxin.Infrastructures.entities;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import java.sql.Timestamp;
import java.time.Instant;

@Embeddable
@Getter
@Setter(AccessLevel.PROTECTED)
public class OperatorValueType extends ValueType {

    private String id;

    private String name;

    private Timestamp createdTime;

    protected OperatorValueType() {
        this.createdTime = Timestamp.from(Instant.now());
    }

    public static OperatorValueType create(String id, String name) {
        OperatorValueType operator = new OperatorValueType();
        operator.setId(id);
        operator.setName(name);

        return operator;
    }
}

