package com.bcxin.Infrastructures.entities;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

@MappedSuperclass
@Getter
@Setter(AccessLevel.PROTECTED)
public abstract class OpEntityAbstract extends EntityAbstract {
    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name = "id",
                    column = @Column(name = "creator_id", nullable = true, length = 150)),
            @AttributeOverride(name = "name",
                    column = @Column(name = "creator_name", nullable = true, length = 200)),
            @AttributeOverride(name = "createdTime",
                    column = @Column(name = "creator_created_time", nullable = true))
    })
    private OperatorValueType creator;

    @Embedded
    @AttributeOverrides({
            @AttributeOverride(name = "id",
                    column = @Column(name = "last_modifier_id", nullable = true, length = 150)),
            @AttributeOverride(name = "name",
                    column = @Column(name = "last_modifier_name", nullable = true, length = 200)),
            @AttributeOverride(name = "createdTime",
                    column = @Column(name = "last_modifier_created_time", nullable = true))
    })
    private OperatorValueType lastModifier;

    public void assignCreator(String id, String name) {
        this.creator = OperatorValueType.create(id, name);
    }

    public void assignModifier(String id, String name) {
        this.lastModifier = OperatorValueType.create(id, name);
    }
}
