package com.bcxin.Infrastructures.components;

import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.URLUtil;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public interface WebFileProvider {
    InputStream download(String path);

    @Component
    static class WebFileProviderImpl implements WebFileProvider
    {
        @Override
        public InputStream download(String path) {
            HttpURLConnection connection = null;
            try {
                path = URLUtil.encode(path);
                URL url = new URL(path);
                connection = (HttpURLConnection) url.openConnection();
                connection.setRequestMethod("GET");
                connection.setDoInput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Accept-Charset", "utf-8");
                connection.setConnectTimeout(20 * 1000);
                final ByteArrayOutputStream output = new ByteArrayOutputStream();

                InputStream inputStream = connection.getInputStream();
                IOUtils.copy(inputStream, output);
                return new ByteArrayInputStream(output.toByteArray());
            } catch (Exception e) {
                e.printStackTrace();

                throw new BadTenantException(String.format("文件(%s)下载失败! 失败原因=%s", path, e.getMessage()));
            } finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }
}
