package com.bcxin.Infrastructures;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;

import lombok.Getter;

public class TenantUserContext implements ContextAware<TenantUserContext.UserModel> {
    public static final String CURRENT_TENANT_USER_INFO = "API.CURRENT_TENANT_USER_INFO";
    private static final ThreadLocal<UserModel> _userContextThread = new ThreadLocal<>();

    @Override
    public UserModel get() {
        return _userContextThread.get();
    }

    @Override
    public void init(UserModel data) {
        _userContextThread.set(data);
    }

    public void init(String token, String tenantUserId) {
        _userContextThread.set(UserModel.create(token, tenantUserId));
    }

    public void assignDetail(String name,String organId,String employeeId,MasterSlaveType masterSlaveType) {
        UserModel model = _userContextThread.get();
        if (model == null) {
            throw new ArgumentTenantException("当前用户上下文无效, 系统未能在AuthFilter执行初始化");
        }

        model.assignDetail(name, organId, employeeId, masterSlaveType);

        _userContextThread.set(model);
    }

    public void reset() {
        _userContextThread.set(null);
    }

    @Getter
    public static class UserModel implements Serializable {
        private final String token;
        private final String id;

        private String name;
        private String organId;
        private String employeeId;
        private boolean isMaster;
        private final Map<String, Object> attachments = new HashMap<>();

        public UserModel(String token, String id) {
            this.id = id;
            this.token = token;
        }

        public void assignDetail(String name, String organId, String employeeId, MasterSlaveType masterSlaveType) {
            this.name = name;
            this.organId = organId;
            this.employeeId = employeeId;
            this.isMaster = masterSlaveType == MasterSlaveType.Master;
        }
        public void assignModel(String organId, String employeeId) {
        	this.organId = organId;
        	this.employeeId = employeeId;
        }

        public static UserModel create(String token, String id) {
            return new UserModel(token, id);
        }
    }
}
