/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures.utils;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;

public class BeanCopyUtil
extends BeanUtils {
    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target) {
        return BeanCopyUtil.copyListProperties(sources, target, null);
    }

    public static <S, T> List<T> copyListProperties(List<S> sources, Supplier<T> target, BeanCopyUtilCallBack<S, T> callBack) {
        ArrayList<T> list = new ArrayList<T>(sources.size());
        for (S source : sources) {
            T t = target.get();
            BeanCopyUtil.copyProperties(source, t, (String[])BeanCopyUtil.getNullPropertyNames(source));
            list.add(t);
            if (callBack == null) continue;
            callBack.callBack(source, t);
        }
        return list;
    }

    public static void copyPropertiesIgNore(Object source, Object target) throws BeansException {
        BeanCopyUtil.copyProperties((Object)source, (Object)target, (String[])BeanCopyUtil.getNullPropertyNames(source));
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    @FunctionalInterface
    public static interface BeanCopyUtilCallBack<S, T> {
        public void callBack(S var1, T var2);
    }
}

