/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.Infrastructures;

import com.bcxin.Infrastructures.ContextAware;
import com.bcxin.Infrastructures.enums.MasterSlaveType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TenantUserContext
implements ContextAware<UserModel> {
    public static final String CURRENT_TENANT_USER_INFO = "API.CURRENT_TENANT_USER_INFO";
    private static final ThreadLocal<UserModel> _userContextThread = new ThreadLocal();

    @Override
    public UserModel get() {
        return _userContextThread.get();
    }

    @Override
    public void init(UserModel data) {
        _userContextThread.set(data);
    }

    public void init(String token, String tenantUserId) {
        _userContextThread.set(UserModel.create(token, tenantUserId));
    }

    public void assignDetail(String name, String organId, String employeeId, MasterSlaveType masterSlaveType) {
        UserModel model = _userContextThread.get();
        if (model == null) {
            throw new ArgumentTenantException("\u5f53\u524d\u7528\u6237\u4e0a\u4e0b\u6587\u65e0\u6548, \u7cfb\u7edf\u672a\u80fd\u5728AuthFilter\u6267\u884c\u521d\u59cb\u5316");
        }
        model.assignDetail(name, organId, employeeId, masterSlaveType);
        _userContextThread.set(model);
    }

    public void reset() {
        _userContextThread.set(null);
    }

    public static class UserModel
    implements Serializable {
        private final String token;
        private final String id;
        private String name;
        private String organId;
        private String employeeId;
        private boolean isMaster;
        private final Map<String, Object> attachments = new HashMap<String, Object>();

        public UserModel(String token, String id) {
            this.id = id;
            this.token = token;
        }

        public void assignDetail(String name, String organId, String employeeId, MasterSlaveType masterSlaveType) {
            this.name = name;
            this.organId = organId;
            this.employeeId = employeeId;
            this.isMaster = masterSlaveType == MasterSlaveType.Master;
        }

        public void assignModel(String organId, String employeeId) {
            this.organId = organId;
            this.employeeId = employeeId;
        }

        public static UserModel create(String token, String id) {
            return new UserModel(token, id);
        }

        public String getToken() {
            return this.token;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getOrganId() {
            return this.organId;
        }

        public String getEmployeeId() {
            return this.employeeId;
        }

        public boolean isMaster() {
            return this.isMaster;
        }

        public Map<String, Object> getAttachments() {
            return this.attachments;
        }
    }
}

