package com.bcxin.auth.web.controller.v5;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.schedule.AuthTask;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.zw.domain.Pctinfo;
import com.bcxin.zw.service.ZWService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 人口信息接口
 * @author zhangyutong
 */
@RestController
@RequestMapping("peopleInfo")
public class PeopleInfoController {

    @Resource
    private ConfigUtil configUtil;

    @Resource
    private AuthTask authTask;

    /**
     * 基本信息
     * @param idNumber
     * @return
     */
    @GetMapping("getPersonnelInformation")
    public AjaxResult getPersonnelInformation(String idNumber) {
        BackgroundService backgroundService = configUtil.getBackGroupService();
        return backgroundService.getPersonnelInformation(idNumber);
    }

    /**
     * 获取身份证查询人口库并且修改保安员人口库地址
     * @param idNumber
     * @return
     */
    @GetMapping("getPersonnelAddress")
    @ResponseBody
    public AjaxResult getPersonnelAddress(String idNumber) {
        BackgroundService backgroundService = configUtil.getBackGroupService();
        //获取并且修改人员信息的人口库地址
        backgroundService.getPersonnelAddress(idNumber);
        return AjaxResult.success("请求成功");
    }

    /**
     * 获取指纹
     * @param idNumber
     * @return
     */
    @RequestMapping("getFingerprint")
    public AjaxResult getFingerprint(String idNumber) {
        ZWService zwService = configUtil.getZWService();
        Pctinfo pctinfo = zwService.getZWByIdnumber(idNumber);
        return AjaxResult.success("请求成功", pctinfo == null ? null : pctinfo.getBarcode());
    }
    //实名认证请求人口
    @PostMapping("PersonnelAuth")
    @ResponseBody
    public AjaxResult PersonnelAuth(String authLogs) {
        List<AuthLog> list = JSONArray.parseArray(authLogs, AuthLog.class);
        List<AuthLog> result = authTask.validateResult(list);
        return AjaxResult.success("请求成功", result);
    }
}
