package com.bcxin.auth.web.controller.v5;


import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.service.impl.SNBackgroundServiceImpl;
import com.bcxin.obpm.util.BJProblemDetailUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhangyutong
 */
@RestController
@RequestMapping("background")
public class BackgroundController {

    @Resource
    private ConfigUtil configUtil;

    @Autowired
    private BJProblemDetailUtil bjProblemDetailUtil;

    @Autowired
    private SNBackgroundServiceImpl snBackgroundService;

    /**
     * 背景筛查
     *
     * @param idNumber 身份证号码
     * @param realName 姓名
     * @return AjaxResult
     */
    @GetMapping("personnelReview")
    public AjaxResult personnelReview(String idNumber, String realName) {
        BackgroundService backgroundService = configUtil.getBackGroupService();
        return backgroundService.personnelReview(idNumber, realName);
    }

    /***
     * 进入问题人员处理页面
     * @return 页面路径
     */
    @GetMapping("/problemDetail")
    public AjaxResult problemDetail(String idnum) {

        AjaxResult result = null;
        if ("SN_AUTH".equalsIgnoreCase(BMSConfig.getName())) {
            result = snBackgroundService.checkPersonInfo(idnum);
        } else if ("BJ_AUTH".equalsIgnoreCase(BMSConfig.getName())) {
            result = bjProblemDetailUtil.checkPersonInfo(idnum);
        } else {
            throw new RuntimeException("不支持该区域");
        }

        return result;
    }
}
