/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils.poi;

import com.bcxin.auth.common.annotation.Excel;
import com.bcxin.auth.common.annotation.Excels;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.core.text.Convert;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.DictUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.file.FileTypeUtils;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.common.utils.file.ImageUtils;
import com.bcxin.auth.common.utils.reflect.ReflectUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    public static final int sheetSize = 65536;
    private String sheetName;
    private Excel.Type type;
    private Workbook wb;
    private Sheet sheet;
    private Map<String, CellStyle> styles;
    private List<T> list;
    private List<Object[]> fields;
    private short maxHeight;
    private Map<Integer, Double> statistics = new HashMap<Integer, Double>();
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("######0.00");
    public Class<T> clazz;

    public ExcelUtil(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void init(List<T> list, String sheetName, Excel.Type type) {
        if (list == null) {
            list = new ArrayList<T>();
        }
        this.list = list;
        this.sheetName = sheetName;
        this.type = type;
        this.createExcelField();
        this.createWorkbook();
    }

    public List<T> importExcel(InputStream is) throws Exception {
        return this.importExcel("", is);
    }

    public List<T> importExcel(String sheetName, InputStream is) throws Exception {
        this.type = Excel.Type.IMPORT;
        this.wb = WorkbookFactory.create((InputStream)is);
        ArrayList<Object> list = new ArrayList<Object>();
        Sheet sheet = null;
        sheet = StringUtils.isNotEmpty(sheetName) ? this.wb.getSheet(sheetName) : this.wb.getSheetAt(0);
        if (sheet == null) {
            throw new IOException("\u6587\u4ef6sheet\u4e0d\u5b58\u5728");
        }
        int rows = sheet.getPhysicalNumberOfRows();
        if (rows > 0) {
            HashMap<String, Integer> cellMap = new HashMap<String, Integer>();
            Row heard = sheet.getRow(0);
            for (int i = 0; i < heard.getPhysicalNumberOfCells(); ++i) {
                Cell cell = heard.getCell(i);
                if (StringUtils.isNotNull(cell)) {
                    String value = this.getCellValue(heard, i).toString();
                    cellMap.put(value, i);
                    continue;
                }
                cellMap.put(null, i);
            }
            Field[] allFields = this.clazz.getDeclaredFields();
            HashMap<Integer, Field> fieldsMap = new HashMap<Integer, Field>();
            for (int col = 0; col < allFields.length; ++col) {
                Field field = allFields[col];
                Excel attr = field.getAnnotation(Excel.class);
                if (attr == null || attr.type() != Excel.Type.ALL && attr.type() != this.type) continue;
                field.setAccessible(true);
                Integer column = (Integer)cellMap.get(attr.name());
                if (column == null) continue;
                fieldsMap.put(column, field);
            }
            for (int i = 1; i < rows; ++i) {
                Row row = sheet.getRow(i);
                Object entity = null;
                for (Map.Entry entry : fieldsMap.entrySet()) {
                    Object val = this.getCellValue(row, (Integer)entry.getKey());
                    entity = entity == null ? (Object)this.clazz.newInstance() : entity;
                    Field field = (Field)fieldsMap.get(entry.getKey());
                    Class<?> fieldType = field.getType();
                    if (String.class == fieldType) {
                        String dateFormat;
                        String s = Convert.toStr(val);
                        val = StringUtils.endsWith((CharSequence)s, (CharSequence)".0") ? StringUtils.substringBefore((String)s, (String)".0") : (StringUtils.isNotEmpty(dateFormat = field.getAnnotation(Excel.class).dateFormat()) ? DateUtils.parseDateToStr(dateFormat, (Date)val) : Convert.toStr(val));
                    } else if ((Integer.TYPE == fieldType || Integer.class == fieldType) && StringUtils.isNumeric((CharSequence)Convert.toStr(val))) {
                        val = Convert.toInt(val);
                    } else if (Long.TYPE == fieldType || Long.class == fieldType) {
                        val = Convert.toLong(val);
                    } else if (Double.TYPE == fieldType || Double.class == fieldType) {
                        val = Convert.toDouble(val);
                    } else if (Float.TYPE == fieldType || Float.class == fieldType) {
                        val = Convert.toFloat(val);
                    } else if (BigDecimal.class == fieldType) {
                        val = Convert.toBigDecimal(val);
                    } else if (Date.class == fieldType) {
                        if (val instanceof String) {
                            val = DateUtils.parseDate(val);
                        } else if (val instanceof Double) {
                            val = DateUtil.getJavaDate((double)((Double)val));
                        }
                    } else if (Boolean.TYPE == fieldType || Boolean.class == fieldType) {
                        val = Convert.toBool(val, false);
                    }
                    if (!StringUtils.isNotNull(fieldType)) continue;
                    Excel attr = field.getAnnotation(Excel.class);
                    String propertyName = field.getName();
                    if (StringUtils.isNotEmpty(attr.targetAttr())) {
                        propertyName = field.getName() + "." + attr.targetAttr();
                    } else if (StringUtils.isNotEmpty(attr.readConverterExp())) {
                        val = ExcelUtil.reverseByExp(Convert.toStr(val), attr.readConverterExp(), attr.separator());
                    } else if (StringUtils.isNotEmpty(attr.dictType())) {
                        val = ExcelUtil.reverseDictByExp(Convert.toStr(val), attr.dictType(), attr.separator());
                    }
                    ReflectUtils.invokeSetter(entity, propertyName, val);
                }
                list.add(entity);
            }
        }
        return list;
    }

    public AjaxResult exportExcel(List<T> list, String sheetName) {
        this.init(list, sheetName, Excel.Type.EXPORT);
        return this.exportExcel();
    }

    public AjaxResult importTemplateExcel(String sheetName) {
        this.init(null, sheetName, Excel.Type.IMPORT);
        return this.exportExcel();
    }

    public AjaxResult exportExcel() {
        OutputStream out = null;
        try {
            double sheetNo = Math.ceil(this.list.size() / 65536);
            int index = 0;
            while ((double)index <= sheetNo) {
                this.createSheet(sheetNo, index);
                Row row = this.sheet.createRow(0);
                int column = 0;
                for (Object[] os : this.fields) {
                    Excel excel = (Excel)os[1];
                    this.createCell(excel, row, column++);
                }
                if (Excel.Type.EXPORT.equals((Object)this.type)) {
                    this.fillExcelData(index, row);
                    this.addStatisticsRow();
                }
                ++index;
            }
            String filename = this.encodingFilename(this.sheetName);
            out = new FileOutputStream(this.getAbsoluteFile(filename));
            this.wb.write(out);
            AjaxResult ajaxResult = AjaxResult.success(filename);
            return ajaxResult;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", (Object)e.getMessage());
            throw new BusinessException("\u5bfc\u51faExcel\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff01");
        }
        finally {
            if (this.wb != null) {
                try {
                    this.wb.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public void fillExcelData(int index, Row row) {
        int startNo = index * 65536;
        int endNo = Math.min(startNo + 65536, this.list.size());
        for (int i = startNo; i < endNo; ++i) {
            row = this.sheet.createRow(i + 1 - startNo);
            T vo = this.list.get(i);
            int column = 0;
            for (Object[] os : this.fields) {
                Field field = (Field)os[0];
                Excel excel = (Excel)os[1];
                field.setAccessible(true);
                this.addCell(excel, row, vo, field, column++);
            }
        }
    }

    private Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        CellStyle style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderRight(BorderStyle.THIN);
        style.setRightBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderLeft(BorderStyle.THIN);
        style.setLeftBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderTop(BorderStyle.THIN);
        style.setTopBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBottomBorderColor(IndexedColors.GREY_50_PERCENT.getIndex());
        Font dataFont = wb.createFont();
        dataFont.setFontName("Arial");
        dataFont.setFontHeightInPoints((short)10);
        style.setFont(dataFont);
        styles.put("data", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        Font headerFont = wb.createFont();
        headerFont.setFontName("Arial");
        headerFont.setFontHeightInPoints((short)10);
        headerFont.setBold(true);
        headerFont.setColor(IndexedColors.WHITE.getIndex());
        style.setFont(headerFont);
        styles.put("header", style);
        style = wb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        Font totalFont = wb.createFont();
        totalFont.setFontName("Arial");
        totalFont.setFontHeightInPoints((short)10);
        style.setFont(totalFont);
        styles.put("total", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.LEFT);
        styles.put("data1", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.CENTER);
        styles.put("data2", style);
        style = wb.createCellStyle();
        style.cloneStyleFrom((CellStyle)styles.get("data"));
        style.setAlignment(HorizontalAlignment.RIGHT);
        styles.put("data3", style);
        return styles;
    }

    public Cell createCell(Excel attr, Row row, int column) {
        Cell cell = row.createCell(column);
        cell.setCellValue(attr.name());
        this.setDataValidation(attr, row, column);
        cell.setCellStyle(this.styles.get("header"));
        return cell;
    }

    public Cell createCell(String columnName, Row row, int column) {
        Cell cell = row.createCell(column);
        cell.setCellValue(columnName);
        cell.setCellStyle(this.styles.get("header"));
        return cell;
    }

    public void setCellVo(Object value, Excel attr, Cell cell) {
        if (Excel.ColumnType.STRING == attr.cellType()) {
            cell.setCellValue(StringUtils.isNull(value) ? attr.defaultValue() : value + attr.suffix());
        } else if (Excel.ColumnType.NUMERIC == attr.cellType()) {
            cell.setCellValue(StringUtils.contains((CharSequence)Convert.toStr(value), (CharSequence)".") ? Convert.toDouble(value) : (double)Convert.toInt(value).intValue());
        } else if (Excel.ColumnType.IMAGE == attr.cellType()) {
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cell.getColumnIndex()), cell.getRow().getRowNum(), (int)((short)(cell.getColumnIndex() + 1)), cell.getRow().getRowNum() + 1);
            String imagePath = Convert.toStr(value);
            if (StringUtils.isNotEmpty(imagePath)) {
                byte[] data = ImageUtils.getImage(imagePath);
                ExcelUtil.getDrawingPatriarch(cell.getSheet()).createPicture((ClientAnchor)anchor, cell.getSheet().getWorkbook().addPicture(data, this.getImageType(data)));
            }
        }
    }

    public static Drawing<?> getDrawingPatriarch(Sheet sheet) {
        if (sheet.getDrawingPatriarch() == null) {
            sheet.createDrawingPatriarch();
        }
        return sheet.getDrawingPatriarch();
    }

    public int getImageType(byte[] value) {
        String type = FileTypeUtils.getFileExtendName(value);
        if ("JPG".equalsIgnoreCase(type)) {
            return 5;
        }
        if ("PNG".equalsIgnoreCase(type)) {
            return 6;
        }
        return 5;
    }

    public void setDataValidation(Excel attr, Row row, int column) {
        if (attr.name().indexOf("\u6ce8\uff1a") >= 0) {
            this.sheet.setColumnWidth(column, 6000);
        } else {
            this.sheet.setColumnWidth(column, (int)((attr.width() + 0.72) * 256.0));
        }
        if (StringUtils.isNotEmpty(attr.prompt())) {
            this.setXSSFPrompt(this.sheet, "", attr.prompt(), 1, 100, column, column);
        }
        if (attr.combo().length > 0) {
            this.setXSSFValidation(this.sheet, attr.combo(), 1, 100, column, column);
        }
    }

    public Cell addCell(Row row, Object data, int column) {
        Cell cell = null;
        try {
            row.setHeight((short)300);
            cell = row.createCell(column);
            int align = 2;
            cell.setCellStyle(this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : "")));
            cell.setCellValue("");
            if (data != null) {
                cell.setCellValue(data.toString());
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25{}", (Throwable)e);
        }
        return cell;
    }

    public Cell addCell(Excel attr, Row row, T vo, Field field, int column) {
        Cell cell = null;
        try {
            row.setHeight(this.maxHeight);
            if (attr.isExport()) {
                cell = row.createCell(column);
                int align = attr.align().value();
                cell.setCellStyle(this.styles.get("data" + (align >= 1 && align <= 3 ? Integer.valueOf(align) : "")));
                Object value = this.getTargetValue(vo, field, attr);
                String dateFormat = attr.dateFormat();
                String readConverterExp = attr.readConverterExp();
                String separator = attr.separator();
                String dictType = attr.dictType();
                if (StringUtils.isNotEmpty(dateFormat) && StringUtils.isNotNull(value)) {
                    cell.setCellValue(DateUtils.parseDateToStr(dateFormat, (Date)value));
                } else if (StringUtils.isNotEmpty(readConverterExp) && StringUtils.isNotNull(value)) {
                    cell.setCellValue(ExcelUtil.convertByExp(Convert.toStr(value), readConverterExp, separator));
                } else if (StringUtils.isNotEmpty(dictType) && StringUtils.isNotNull(value)) {
                    cell.setCellValue(ExcelUtil.convertDictByExp(Convert.toStr(value), dictType, separator));
                } else if (value instanceof BigDecimal && -1 != attr.scale()) {
                    cell.setCellValue(((BigDecimal)value).setScale(attr.scale(), attr.roundingMode()).toString());
                } else {
                    this.setCellVo(value, attr, cell);
                }
                this.addStatisticsData(column, Convert.toStr(value), attr);
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5931\u8d25{}", (Throwable)e);
        }
        return cell;
    }

    public void setXSSFPrompt(Sheet sheet, String promptTitle, String promptContent, int firstRow, int endRow, int firstCol, int endCol) {
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createCustomConstraint("DD1");
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        DataValidation dataValidation = helper.createValidation(constraint, regions);
        dataValidation.createPromptBox(promptTitle, promptContent);
        dataValidation.setShowPromptBox(true);
        sheet.addValidationData(dataValidation);
    }

    public void setXSSFValidation(Sheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        CellRangeAddressList regions;
        DataValidationConstraint constraint;
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidation dataValidation = helper.createValidation(constraint = helper.createExplicitListConstraint(textlist), regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol));
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
    }

    public static String convertByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[0].equals(value)) continue;
                    propertyString.append(itemArray[1] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[0].equals(propertyValue)) continue;
            return itemArray[1];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String reverseByExp(String propertyValue, String converterExp, String separator) {
        String[] convertSource;
        StringBuilder propertyString = new StringBuilder();
        block0: for (String item : convertSource = converterExp.split(",")) {
            String[] itemArray = item.split("=");
            if (StringUtils.containsAny((CharSequence)separator, (CharSequence)propertyValue)) {
                for (String value : propertyValue.split(separator)) {
                    if (!itemArray[1].equals(value)) continue;
                    propertyString.append(itemArray[0] + separator);
                    continue block0;
                }
                continue;
            }
            if (!itemArray[1].equals(propertyValue)) continue;
            return itemArray[0];
        }
        return StringUtils.stripEnd((String)propertyString.toString(), (String)separator);
    }

    public static String convertDictByExp(String dictValue, String dictType, String separator) {
        return DictUtils.getDictLabel(dictType, dictValue, separator);
    }

    public static String reverseDictByExp(String dictLabel, String dictType, String separator) {
        return DictUtils.getDictValue(dictType, dictLabel, separator);
    }

    private void addStatisticsData(Integer index, String text, Excel entity) {
        if (entity != null && entity.isStatistics()) {
            Double temp = 0.0;
            if (!this.statistics.containsKey(index)) {
                this.statistics.put(index, temp);
            }
            try {
                temp = Double.valueOf(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.statistics.put(index, this.statistics.get(index) + temp);
        }
    }

    public void addStatisticsRow() {
        if (this.statistics.size() > 0) {
            Cell cell = null;
            Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
            Set<Integer> keys = this.statistics.keySet();
            cell = row.createCell(0);
            cell.setCellStyle(this.styles.get("total"));
            cell.setCellValue("\u5408\u8ba1");
            for (Integer key : keys) {
                cell = row.createCell(key.intValue());
                cell.setCellStyle(this.styles.get("total"));
                cell.setCellValue(DOUBLE_FORMAT.format(this.statistics.get(key)));
            }
            this.statistics.clear();
        }
    }

    public String encodingFilename(String filename) {
        filename = UUID.randomUUID().toString() + "_" + filename + ".xlsx";
        return filename;
    }

    public String encodingFilename(String filename, String fileType) {
        filename = UUID.randomUUID().toString() + "_" + filename + fileType;
        return filename;
    }

    public String getAbsoluteFile(String filename) {
        String downloadPath = BMSConfig.getDownloadPath() + filename;
        File desc = new File(downloadPath);
        if (!desc.getParentFile().exists()) {
            desc.getParentFile().mkdirs();
        }
        return downloadPath;
    }

    private Object getTargetValue(T vo, Field field, Excel excel) throws Exception {
        Object o = field.get(vo);
        if (StringUtils.isNotEmpty(excel.targetAttr())) {
            String target = excel.targetAttr();
            if (target.indexOf(".") > -1) {
                String[] targets;
                for (String name : targets = target.split("[.]")) {
                    o = this.getValue(o, name);
                }
            } else {
                o = this.getValue(o, target);
            }
        }
        return o;
    }

    private Object getValue(Object o, String name) throws Exception {
        if (StringUtils.isNotNull(o) && StringUtils.isNotEmpty(name)) {
            Class<?> clazz = o.getClass();
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            o = field.get(o);
        }
        return o;
    }

    private void createExcelField() {
        this.fields = new ArrayList<Object[]>();
        ArrayList<Field> tempFields = new ArrayList<Field>();
        tempFields.addAll(Arrays.asList(this.clazz.getSuperclass().getDeclaredFields()));
        tempFields.addAll(Arrays.asList(this.clazz.getDeclaredFields()));
        for (Field field : tempFields) {
            Excel[] excels;
            if (field.isAnnotationPresent(Excel.class)) {
                this.putToField(field, field.getAnnotation(Excel.class));
            }
            if (!field.isAnnotationPresent(Excels.class)) continue;
            Excels attrs = field.getAnnotation(Excels.class);
            for (Excel excel : excels = attrs.value()) {
                this.putToField(field, excel);
            }
        }
        this.fields = this.fields.stream().sorted(Comparator.comparing(objects -> ((Excel)objects[1]).sort())).collect(Collectors.toList());
        this.maxHeight = this.getRowHeight();
    }

    public short getRowHeight() {
        double maxHeight = 0.0;
        for (Object[] os : this.fields) {
            Excel excel = (Excel)os[1];
            maxHeight = maxHeight > excel.height() ? maxHeight : excel.height();
        }
        return (short)(maxHeight * 20.0);
    }

    private void putToField(Field field, Excel attr) {
        if (attr != null && (attr.type() == Excel.Type.ALL || attr.type() == this.type)) {
            this.fields.add(new Object[]{field, attr});
        }
    }

    public void createWorkbook() {
        this.wb = new SXSSFWorkbook(500);
    }

    public void createSheet(double sheetNo, int index) {
        this.sheet = this.wb.createSheet();
        this.styles = this.createStyles(this.wb);
        if (sheetNo == 0.0) {
            this.wb.setSheetName(index, this.sheetName);
        } else {
            this.wb.setSheetName(index, this.sheetName + index);
        }
    }

    public Object getCellValue(Row row, int column) {
        if (row == null) {
            return row;
        }
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (StringUtils.isNotNull(cell)) {
                if (cell.getCellType() == CellType.NUMERIC.getCode() || cell.getCellType() == CellType.FORMULA.getCode()) {
                    val = cell.getNumericCellValue();
                    val = DateUtil.isCellDateFormatted((Cell)cell) ? DateUtil.getJavaDate((double)((Double)val)) : ((Double)val % 1.0 != 0.0 ? new BigDecimal(val.toString()) : new DecimalFormat("0").format(val));
                } else if (cell.getCellType() == CellType.STRING.getCode()) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == CellType.BOOLEAN.getCode()) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == CellType.ERROR.getCode()) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public AjaxResult exportExcelForMap(List<Map> list, String sheetName) {
        OutputStream out = null;
        try {
            this.sheetName = sheetName;
            this.createWorkbook();
            this.createSheet(0.0, 0);
            Row row = this.sheet.createRow(0);
            row.setHeight((short)300);
            int column = 0;
            int index = 1;
            Map detail = list.get(0);
            LinkedHashMap tableColumn = new LinkedHashMap();
            for (Object key : detail.keySet()) {
                this.createCell(key.toString(), row, column++);
            }
            for (Map map : list) {
                column = 0;
                row = this.sheet.createRow(index++);
                for (Object key : detail.keySet()) {
                    this.addCell(row, map.get(key), column++);
                }
            }
            String filename = this.encodingFilename(sheetName);
            out = new FileOutputStream(this.getAbsoluteFile(filename));
            this.wb.write(out);
            AjaxResult ajaxResult = AjaxResult.success(filename);
            return ajaxResult;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faExcel\u5f02\u5e38{}", (Object)e.getMessage());
            throw new BusinessException("\u5bfc\u51faExcel\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff01");
        }
        finally {
            if (this.wb != null) {
                try {
                    this.wb.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public AjaxResult exportInsertSql(List<Map> list, String sheetName) {
        try {
            Map detail = list.get(0);
            StringBuilder content = new StringBuilder("INSERT INTO `tableName` (");
            for (Object key : detail.keySet()) {
                content.append("`" + key + "`,");
            }
            content.deleteCharAt(content.length() - 1);
            content.append(") \r\nVALUES ");
            for (Map map : list) {
                content.append("(");
                for (Object key : detail.keySet()) {
                    if (map.get(key) != null) {
                        content.append("'" + map.get(key) + "',");
                        continue;
                    }
                    content.append("null,");
                }
                content.deleteCharAt(content.length() - 1);
                content.append("),\r\n");
            }
            content.deleteCharAt(content.length() - 3);
            content.append(";");
            String filename = this.encodingFilename(sheetName, ".txt");
            String filepath = FileUtils.writeFile(content.toString(), filename, BMSConfig.getDownloadPath());
            String zipFileName = this.encodingFilename(sheetName, ".zip");
            String zipFilePath = BMSConfig.getDownloadPath() + zipFileName;
            FileUtils.zipFile(filepath, zipFilePath);
            FileUtils.deleteFile(filepath);
            AjaxResult ajaxResult = AjaxResult.success(zipFileName);
            return ajaxResult;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fasql\u5f02\u5e38{}", (Object)e.getMessage());
            throw new BusinessException("\u5bfc\u51fasql\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff01");
        }
        finally {
            if (this.wb != null) {
                try {
                    this.wb.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public AjaxResult exportUpdateSql(List<Map> list, String sheetName, String columnName) {
        try {
            Map detail = list.get(0);
            StringBuilder content = new StringBuilder("");
            for (Map map : list) {
                content.append("UPDATE `tableName` set ");
                for (Object key : detail.keySet()) {
                    content.append(key + "=");
                    if (map.get(key) != null) {
                        content.append("'" + map.get(key) + "',");
                        continue;
                    }
                    content.append("null,");
                }
                content.deleteCharAt(content.length() - 1);
                content.append(" where " + columnName + "='" + map.get(columnName) + "';\r\n");
            }
            String filename = this.encodingFilename(sheetName, ".sql");
            String filepath = FileUtils.writeFile(content.toString(), filename, BMSConfig.getDownloadPath());
            String zipFileName = this.encodingFilename(sheetName, ".zip");
            String zipFilePath = BMSConfig.getDownloadPath() + zipFileName;
            FileUtils.zipFile(filepath, zipFilePath);
            FileUtils.deleteFile(filepath);
            AjaxResult ajaxResult = AjaxResult.success(zipFileName);
            return ajaxResult;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fasql\u5f02\u5e38{}", (Object)e.getMessage());
            throw new BusinessException("\u5bfc\u51fasql\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ad9\u7ba1\u7406\u5458\uff01");
        }
        finally {
            if (this.wb != null) {
                try {
                    this.wb.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }
}

