/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;

public class HttpClientUtil {
    private static final Log log = LogFactory.getLog(HttpClientUtils.class);
    private static HttpClient httpClient = null;
    public static CookieStore cookieStore = null;

    public static HttpClient getHttpClient() {
        if (httpClient == null) {
            httpClient = new DefaultHttpClient((ClientConnectionManager)new ThreadSafeClientConnManager());
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String url, List<NameValuePair> params) {
        HttpClient httpclient = HttpClientUtil.getHttpClient();
        HttpPost post = new HttpPost(url);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        String responseJson = null;
        try {
            if (params != null) {
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            }
            responseJson = (String)HttpClientUtil.getHttpClient().execute((HttpUriRequest)post, (ResponseHandler)responseHandler);
            log.info((Object)("HttpClient POST\u8bf7\u6c42\u7ed3\u679c\uff1a" + responseJson));
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.info((Object)("HttpClient POST\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            httpclient.getConnectionManager().closeExpiredConnections();
            httpclient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        }
        return responseJson;
    }

    public static String doPost(String postUrl, List<NameValuePair> parameterList) {
        String retStr = "";
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Object closeableHttpClient = null;
        HttpPost httpPost = new HttpPost(postUrl);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).build();
        httpPost.setConfig(requestConfig);
        try {
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameterList, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = response.getEntity();
            retStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            closeableHttpClient.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)("HttpClient POST\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        return retStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject post(String serverUrl, String data) {
        StringBuilder responseBuilder = null;
        BufferedReader reader = null;
        OutputStreamWriter wr = null;
        JSONObject jsonObject = new JSONObject();
        try {
            URL url = new URL(serverUrl);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setConnectTimeout(5000);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            responseBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line + "\n");
            }
            log.debug((Object)responseBuilder.toString());
            jsonObject = JSON.parseObject((String)responseBuilder.toString());
        }
        catch (IOException var22) {
            log.error((Object)"", (Throwable)var22);
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException var21) {
                    log.error((Object)"close error", (Throwable)var21);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException var20) {
                    log.error((Object)"close error", (Throwable)var20);
                }
            }
        }
        return jsonObject;
    }

    public static JSONObject executeByGET(String url, Object[] params) {
        HttpClient httpclient = HttpClientUtil.getHttpClient();
        String messages = MessageFormat.format(url, params);
        HttpGet get = new HttpGet(messages);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        JSONObject responseJson = null;
        responseJson = HttpClientUtil.getJsonObject(httpclient, get, (ResponseHandler<String>)responseHandler, responseJson);
        return responseJson;
    }

    public static JSONObject executeByGET(String url) {
        HttpClient httpclient = HttpClientUtil.getHttpClient();
        HttpGet get = new HttpGet(url);
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        JSONObject responseJson = null;
        responseJson = HttpClientUtil.getJsonObject(httpclient, get, (ResponseHandler<String>)responseHandler, responseJson);
        return responseJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getJsonObject(HttpClient httpclient, HttpGet get, ResponseHandler<String> responseHandler, JSONObject responseJson) {
        try {
            responseJson = JSONObject.parseObject((String)((String)httpclient.execute((HttpUriRequest)get, responseHandler)));
            log.info((Object)("HttpClient GET\u8bf7\u6c42\u7ed3\u679c\uff1a" + responseJson));
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            log.info((Object)("HttpClient GET\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info((Object)("HttpClient GET\u8bf7\u6c42\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        finally {
            httpclient.getConnectionManager().closeExpiredConnections();
            httpclient.getConnectionManager().closeIdleConnections(30L, TimeUnit.SECONDS);
        }
        return responseJson;
    }
}

