/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils;

import com.bcxin.auth.common.core.domain.entity.SysUser;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.bean.BeanUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;

public class ShiroUtils {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static Session getSession() {
        return SecurityUtils.getSubject().getSession();
    }

    public static void logout() {
        ShiroUtils.getSubject().logout();
    }

    public static SysUser getSysUser() {
        SysUser user = null;
        Object obj = ShiroUtils.getSubject().getPrincipal();
        if (StringUtils.isNotNull(obj)) {
            user = new SysUser();
            BeanUtils.copyBeanProp(user, obj);
        }
        return user;
    }

    public static void setSysUser(SysUser user) {
        Subject subject = ShiroUtils.getSubject();
        PrincipalCollection principalCollection = subject.getPrincipals();
        String realmName = (String)principalCollection.getRealmNames().iterator().next();
        SimplePrincipalCollection newPrincipalCollection = new SimplePrincipalCollection((Object)user, realmName);
        subject.runAs((PrincipalCollection)newPrincipalCollection);
    }

    public static Long getUserId() {
        return (long)ShiroUtils.getSysUser().getUserId();
    }

    public static String getStrUserId() {
        return ShiroUtils.getSysUser().getUserId() + "";
    }

    public static String getLoginName() {
        return ShiroUtils.getSysUser().getLoginName();
    }

    public static String getIp() {
        return ShiroUtils.getSubject().getSession().getHost();
    }

    public static String getSessionId() {
        return String.valueOf(ShiroUtils.getSubject().getSession().getId());
    }

    public static String randomSalt() {
        SecureRandomNumberGenerator secureRandom = new SecureRandomNumberGenerator();
        String hex = secureRandom.nextBytes(3).toHex();
        return hex;
    }
}

