/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils.security;

import com.bcxin.auth.common.utils.MessageUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionUtils {
    private static final Logger log = LoggerFactory.getLogger(PermissionUtils.class);
    public static final String VIEW_PERMISSION = "no.view.permission";
    public static final String CREATE_PERMISSION = "no.create.permission";
    public static final String UPDATE_PERMISSION = "no.update.permission";
    public static final String DELETE_PERMISSION = "no.delete.permission";
    public static final String EXPORT_PERMISSION = "no.export.permission";
    public static final String PERMISSION = "no.permission";

    public static String getMsg(String permissionsStr) {
        String permission = StringUtils.substringBetween((String)permissionsStr, (String)"[", (String)"]");
        String msg = MessageUtils.message(PERMISSION, permission);
        if (StringUtils.endsWithIgnoreCase((CharSequence)permission, (CharSequence)"add")) {
            msg = MessageUtils.message(CREATE_PERMISSION, permission);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)permission, (CharSequence)"edit")) {
            msg = MessageUtils.message(UPDATE_PERMISSION, permission);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)permission, (CharSequence)"remove")) {
            msg = MessageUtils.message(DELETE_PERMISSION, permission);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)permission, (CharSequence)"export")) {
            msg = MessageUtils.message(EXPORT_PERMISSION, permission);
        } else if (StringUtils.endsWithAny((CharSequence)permission, (CharSequence[])new String[]{"view", "list"})) {
            msg = MessageUtils.message(VIEW_PERMISSION, permission);
        }
        return msg;
    }

    public static Object getPrincipalProperty(String property) {
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            Object principal = subject.getPrincipal();
            try {
                BeanInfo bi = Introspector.getBeanInfo(principal.getClass());
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    if (!pd.getName().equals(property)) continue;
                    return pd.getReadMethod().invoke(principal, (Object[])null);
                }
            }
            catch (Exception e) {
                log.error("Error reading property [{}] from principal of type [{}]", (Object)property, (Object)principal.getClass().getName());
            }
        }
        return null;
    }
}

