DROP TABLE IF EXISTS datasync_log;
CREATE TABLE `datasync_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `basePath` varchar(100) DEFAULT NULL COMMENT '基础路径',
  `filePath` varchar(200) DEFAULT NULL COMMENT '文件路径',
  `fileName` varchar(100) DEFAULT NULL COMMENT '文件名',
  `url` varchar(200) DEFAULT NULL COMMENT '访问路径',
  `businessType` varchar(6) DEFAULT NULL COMMENT '类型 0业务数据 1客户上传附件 2警官上传附件',
  `msgId` varchar(30) DEFAULT NULL COMMENT '同步返回id',
  `dataSyncState` char(5) DEFAULT '0' COMMENT '同步状态',
  `errorInfo` varchar(500) DEFAULT NULL COMMENT '同步失败信息',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='数据同步记录';


INSERT INTO `sys_config` (`config_name`, `config_key`, `config_value`, `config_type`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('数据同步日期', 'DATASYNC_DATE', '2021-09-17', 'Y', 'auth_super', '2021-09-17 10:54:45', '', NULL, NULL);

UPDATE `sys_config` SET `config_value`='1' WHERE `config_key`='TOFTP';
#FTP服务地址 广西内网ftp服务
UPDATE `sys_config` SET `config_value`='http://10.148.77.214:8007/' WHERE `config_key`='FTP_HOST';
#源地址 南宁内网认证
UPDATE `sys_config` SET `config_value`='http://71.30.36.39:8006/' WHERE `config_key`='SRC_HOST';
#目录地址 南宁外网认证
UPDATE `sys_config` SET `config_value`='http://219.159.71.176:9680' WHERE `config_key`='TARGET_HOST';

INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('3', '获取待认证同步文件', 'DEFAULT', 'dataSyncFileTask.run()', '0 */2 * * * ?', '1', '1', '0', 'auth_super', '2021-09-17 13:32:11', 'auth_super', '2021-09-17 17:06:05', '');
INSERT INTO `sys_job` (`job_id`, `job_name`, `job_group`, `invoke_target`, `cron_expression`, `misfire_policy`, `concurrent`, `status`, `create_by`, `create_time`, `update_by`, `update_time`, `remark`) VALUES ('4', '认证同步调摆渡服务', 'DEFAULT', 'dataSyncFtpTask.run()', '0 */3 * * * ?', '1', '1', '0', 'auth_super', '2021-09-17 13:38:15', 'auth_super', '2021-09-17 17:05:59', '');
