/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.shiro.web.session;

import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.common.utils.bean.BeanUtils;
import com.bcxin.auth.common.utils.spring.SpringUtils;
import com.bcxin.auth.framework.shiro.session.OnlineSession;
import com.bcxin.auth.system.domain.SysUserOnline;
import com.bcxin.auth.system.service.ISysUserOnlineService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineWebSessionManager
extends DefaultWebSessionManager {
    private static final Logger log = LoggerFactory.getLogger(OnlineWebSessionManager.class);

    public void setAttribute(SessionKey sessionKey, Object attributeKey, Object value) throws InvalidSessionException {
        super.setAttribute(sessionKey, attributeKey, value);
        if (value != null && this.needMarkAttributeChanged(attributeKey)) {
            OnlineSession session = this.getOnlineSession(sessionKey);
            session.markAttributeChanged();
        }
    }

    private boolean needMarkAttributeChanged(Object attributeKey) {
        if (attributeKey == null) {
            return false;
        }
        String attributeKeyStr = attributeKey.toString();
        if (attributeKeyStr.startsWith("org.springframework")) {
            return false;
        }
        if (attributeKeyStr.startsWith("javax.servlet")) {
            return false;
        }
        return !attributeKeyStr.equals("username");
    }

    public Object removeAttribute(SessionKey sessionKey, Object attributeKey) throws InvalidSessionException {
        Object removed = super.removeAttribute(sessionKey, attributeKey);
        if (removed != null) {
            OnlineSession s = this.getOnlineSession(sessionKey);
            s.markAttributeChanged();
        }
        return removed;
    }

    public OnlineSession getOnlineSession(SessionKey sessionKey) {
        OnlineSession session = null;
        Session obj = this.doGetSession(sessionKey);
        if (StringUtils.isNotNull((Object)obj)) {
            session = new OnlineSession();
            BeanUtils.copyBeanProp((Object)((Object)session), (Object)obj);
        }
        return session;
    }

    public void validateSessions() {
        if (log.isInfoEnabled()) {
            log.info("invalidation sessions...");
        }
        int invalidCount = 0;
        int timeout = (int)this.getGlobalSessionTimeout();
        if (timeout < 0) {
            return;
        }
        Date expiredDate = DateUtils.addMilliseconds((Date)new Date(), (int)(0 - timeout));
        ISysUserOnlineService userOnlineService = (ISysUserOnlineService)SpringUtils.getBean(ISysUserOnlineService.class);
        List userOnlineList = userOnlineService.selectOnlineByExpired(expiredDate);
        ArrayList<String> needOfflineIdList = new ArrayList<String>();
        for (SysUserOnline userOnline : userOnlineList) {
            try {
                DefaultSessionKey key = new DefaultSessionKey((Serializable)((Object)userOnline.getSessionId()));
                Session session = this.retrieveSession((SessionKey)key);
                if (session == null) continue;
                throw new InvalidSessionException();
            }
            catch (InvalidSessionException e) {
                if (log.isDebugEnabled()) {
                    boolean expired = e instanceof ExpiredSessionException;
                    String msg = "Invalidated session with id [" + userOnline.getSessionId() + "]" + (expired ? " (expired)" : " (stopped)");
                    log.debug(msg);
                }
                ++invalidCount;
                needOfflineIdList.add(userOnline.getSessionId());
                userOnlineService.removeUserCache(userOnline.getLoginName(), userOnline.getSessionId());
            }
        }
        if (needOfflineIdList.size() > 0) {
            try {
                userOnlineService.batchDeleteOnline(needOfflineIdList);
            }
            catch (Exception e) {
                log.error("batch delete db session error.", (Throwable)e);
            }
        }
        if (log.isInfoEnabled()) {
            String msg = "Finished invalidation session.";
            msg = invalidCount > 0 ? msg + " [" + invalidCount + "] sessions were stopped." : msg + " No sessions were stopped.";
            log.info(msg);
        }
    }

    protected Collection<Session> getActiveSessions() {
        throw new UnsupportedOperationException("getActiveSessions method not supported");
    }
}

