/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.shiro.service;

import com.bcxin.auth.common.core.domain.entity.SysUser;
import com.bcxin.auth.common.exception.user.UserPasswordNotMatchException;
import com.bcxin.auth.common.exception.user.UserPasswordRetryLimitExceedException;
import com.bcxin.auth.common.utils.MessageUtils;
import com.bcxin.auth.framework.manager.AsyncManager;
import com.bcxin.auth.framework.manager.factory.AsyncFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SysPasswordService {
    @Autowired
    private CacheManager cacheManager;
    private Cache<String, AtomicInteger> loginRecordCache;
    @Value(value="${user.password.maxRetryCount}")
    private String maxRetryCount;

    @PostConstruct
    public void init() {
        this.loginRecordCache = this.cacheManager.getCache("loginRecordCache");
    }

    public void validate(SysUser user, String password) {
        String loginName = user.getLoginName();
        AtomicInteger retryCount = (AtomicInteger)this.loginRecordCache.get((Object)loginName);
        if (retryCount == null) {
            retryCount = new AtomicInteger(0);
            this.loginRecordCache.put((Object)loginName, (Object)retryCount);
        }
        if (retryCount.incrementAndGet() > Integer.valueOf(this.maxRetryCount)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(loginName, "Error", MessageUtils.message((String)"user.password.retry.limit.exceed", (Object[])new Object[]{this.maxRetryCount}), new Object[0]));
            throw new UserPasswordRetryLimitExceedException(Integer.valueOf(this.maxRetryCount).intValue());
        }
        if (!this.matches(user, password)) {
            AsyncManager.me().execute(AsyncFactory.recordLogininfor(loginName, "Error", MessageUtils.message((String)"user.password.retry.limit.count", (Object[])new Object[]{retryCount}), new Object[0]));
            this.loginRecordCache.put((Object)loginName, (Object)retryCount);
            throw new UserPasswordNotMatchException();
        }
        this.clearLoginRecordCache(loginName);
    }

    public boolean matches(SysUser user, String newPassword) {
        return user.getPassword().equals(this.encryptPassword(user.getLoginName(), newPassword, user.getSalt()));
    }

    public void clearLoginRecordCache(String loginName) {
        this.loginRecordCache.remove((Object)loginName);
    }

    public String encryptPassword(String loginName, String password, String salt) {
        return new Md5Hash((Object)(loginName + password + salt)).toHex();
    }

    public static void main(String[] args) {
        System.out.println(new Md5Hash((Object)"auth_superAuth#071202@111111").toHex());
    }
}

