/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.aspectj;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.bcxin.auth.common.annotation.Log;
import com.bcxin.auth.common.core.domain.entity.SysUser;
import com.bcxin.auth.common.enums.BusinessStatus;
import com.bcxin.auth.common.json.JSON;
import com.bcxin.auth.common.utils.ServletUtils;
import com.bcxin.auth.common.utils.ShiroUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.framework.manager.AsyncManager;
import com.bcxin.auth.framework.manager.factory.AsyncFactory;
import com.bcxin.auth.system.domain.SysOperLog;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    public static final String[] EXCLUDE_PROPERTIES = new String[]{"password", "oldPassword", "newPassword", "confirmPassword"};

    @Pointcut(value="@annotation(com.bcxin.auth.common.annotation.Log)")
    public void logPointCut() {
    }

    @AfterReturning(pointcut="logPointCut()", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, Object jsonResult) {
        this.handleLog(joinPoint, null, jsonResult);
    }

    @AfterThrowing(value="logPointCut()", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, Exception e) {
        this.handleLog(joinPoint, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, Exception e, Object jsonResult) {
        try {
            Log controllerLog = this.getAnnotationLog(joinPoint);
            if (controllerLog == null) {
                return;
            }
            SysUser currentUser = ShiroUtils.getSysUser();
            SysOperLog operLog = new SysOperLog();
            operLog.setStatus(Integer.valueOf(BusinessStatus.SUCCESS.ordinal()));
            String ip = ShiroUtils.getIp();
            operLog.setOperIp(ip);
            operLog.setJsonResult(StringUtils.substring((String)JSON.marshal((Object)jsonResult), (int)0, (int)2000));
            operLog.setOperUrl(ServletUtils.getRequest().getRequestURI());
            if (currentUser != null) {
                operLog.setOperName(currentUser.getLoginName());
                if (StringUtils.isNotNull((Object)currentUser.getDept()) && StringUtils.isNotEmpty((String)currentUser.getDept().getDeptName())) {
                    operLog.setDeptName(currentUser.getDept().getDeptName());
                }
            }
            if (e != null) {
                operLog.setStatus(Integer.valueOf(BusinessStatus.FAIL.ordinal()));
                operLog.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            operLog.setMethod(className + "." + methodName + "()");
            operLog.setRequestMethod(ServletUtils.getRequest().getMethod());
            this.getControllerMethodDescription(controllerLog, operLog);
            AsyncManager.me().execute(AsyncFactory.recordOper(operLog));
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    public void getControllerMethodDescription(Log log, SysOperLog operLog) throws Exception {
        operLog.setBusinessType(Integer.valueOf(log.businessType().ordinal()));
        operLog.setTitle(log.title());
        operLog.setOperatorType(Integer.valueOf(log.operatorType().ordinal()));
        if (log.isSaveRequestData()) {
            this.setRequestValue(operLog);
        }
    }

    private void setRequestValue(SysOperLog operLog) throws Exception {
        Map map = ServletUtils.getRequest().getParameterMap();
        if (StringUtils.isNotEmpty((Map)map)) {
            PropertyPreFilters.MySimplePropertyPreFilter excludefilter = new PropertyPreFilters().addFilter();
            excludefilter.addExcludes(EXCLUDE_PROPERTIES);
            String params = JSONObject.toJSONString((Object)map, (SerializeFilter)excludefilter, (SerializerFeature[])new SerializerFeature[0]);
            operLog.setOperParam(StringUtils.substring((String)params, (int)0, (int)2000));
        }
    }

    private Log getAnnotationLog(JoinPoint joinPoint) throws Exception {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(Log.class);
        }
        return null;
    }
}

