
DROP TABLE IF EXISTS `com_base_info`;
CREATE TABLE `com_base_info` (
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `comName` varchar(50) DEFAULT NULL COMMENT '公司名称',
  `comTreeCode` varchar(200) NOT NULL COMMENT '企业树代码',
  `tlkComId` varchar(100) NOT NULL COMMENT 'V5企业id',
  PRIMARY KEY (`comId`),
  KEY `index_com_base_info_comTreeCode` (`comTreeCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='企业信息';




DROP TABLE IF EXISTS `per_base_info`;
CREATE TABLE `per_base_info` (
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `userId` bigint(20) DEFAULT NULL COMMENT '用户ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `idCardType` varchar(6) DEFAULT NULL COMMENT '身份证件类型',
  `idCardNo` varchar(20) DEFAULT NULL COMMENT '证件号码',
  `name` varchar(50) DEFAULT NULL COMMENT '姓名',
  `isIncumbency` varchar(1) DEFAULT '1' COMMENT '是否在职',
  `mobilePhone` varchar(20) DEFAULT NULL COMMENT '手机号',
  `tlkPerId` varchar(200) DEFAULT NULL COMMENT 'V5人员id',
  PRIMARY KEY (`perId`),
  UNIQUE KEY `index_per_base_info_mobilePhone` (`mobilePhone`) USING BTREE,
  KEY `index_per_base_info_idCardNo` (`idCardNo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员信息';



DROP TABLE IF EXISTS `per_org_relation`;
CREATE TABLE `per_org_relation` (
  `perOrgRelationId` bigint(20) NOT NULL COMMENT '人员组织关系ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `orgType` varchar(1) DEFAULT NULL COMMENT '所在组织类型',
  `orgId` bigint(20) NOT NULL COMMENT '所在组织ID',
  `perId` bigint(20) NOT NULL COMMENT '人员ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  PRIMARY KEY (`perOrgRelationId`),
  KEY `index_per_org_relation_comId` (`comId`),
  KEY `index_per_org_relation_orgId` (`orgId`),
  KEY `index_per_org_relation_perId` (`perId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='人员组织关系';

DROP TABLE IF EXISTS `com_depart`;
CREATE TABLE `com_depart` (
  `departId` bigint(20) NOT NULL COMMENT '部门ID',
  `createTime` datetime NOT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `isDelete` varchar(1) DEFAULT '0' COMMENT '是否逻辑删除',
  `departName` varchar(30) NOT NULL COMMENT '部门名称',
  `seq` int(6) DEFAULT NULL COMMENT '排序',
  `departTreeCode` varchar(200) DEFAULT NULL COMMENT '部门树查询代码',
  `parentDepartId` bigint(20) DEFAULT NULL COMMENT '上级部门ID',
  `comId` bigint(20) NOT NULL COMMENT '企业ID',
  `tlkDepartId` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`departId`),
  KEY `index_com_depart_comId` (`comId`),
  KEY `index_com_depart_departTreeCode` (`departTreeCode`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='部门';



create table per_huawei_meet_match
(
    perId                   bigint                 not null comment '人员ID'
        primary key,
    createTime              datetime               not null comment '创建时间',
    createBy                bigint                 null comment '创建人ID',
    isActive                varchar(1) default '1' null comment '是否启用',
    huaweiUserName          varchar(100)           null comment '华为云会议用户名',
    huaweiPassWord          varchar(50)            null comment '华为云会议密码',
    huaweiUserId            varchar(50)            null comment '华为云用户ID',
    huaweiSipName           varchar(50)            null comment '华为云用户SIP号码',
    regulatorMeetChargeType varchar(6) default '0' null comment '监管会议负责人类型'
)
    comment '人员华为云会议映射';

create table com_huawei_meet_match
(
    comId                bigint                 not null comment '企业ID'
        primary key,
    createTime           datetime               not null comment '创建时间',
    createBy             bigint                 null comment '创建人ID',
    isActive             varchar(1) default '1' null comment '是否启用',
    huaweiComId          bigint                 null comment '华为云会议企业ID',
    huaweiManageUserName varchar(50)            null comment '华为云会议管理员用户',
    huaweiManagePassWord varchar(50)            null comment '华为云会议管理员密码'
)
    comment '企业华为云会议映射';


