
drop table if exists task_card_remind;
drop table if exists temp_batch_task_schedul_import;
drop table if exists temp_com_wallet_reconciliation;
drop table if exists temp_count_per_attend_date;
drop table if exists temp_count_per_task_date;
drop table if exists temp_task_schedul_check;
drop table if exists com_shift;
drop table if exists com_shift_rule;
drop table if exists com_task;
drop table if exists com_task_approve;
drop table if exists com_task_attend_address;
drop table if exists com_task_attend_wifi;
drop table if exists com_task_behalf;
drop table if exists com_task_charge_record;
drop table if exists com_task_contract;
drop table if exists com_task_cycle_shift;
drop table if exists com_task_feedback;
drop table if exists com_task_fixed;
drop table if exists com_task_free;
drop table if exists com_task_implement;
drop table if exists com_task_inside_push;

drop table if exists com_task_mid_control;
drop table if exists com_task_oper_process;
drop table if exists com_task_reinforce;
drop table if exists com_task_schedul;
drop table if exists com_task_schedul_cycle;
drop table if exists com_task_shift;

drop table if exists count_task_execute_record;
drop table if exists count_per_task_date;
drop table if exists count_per_task_approve_date;
drop table if exists mid_task;
drop table if exists mid_task_detail;
drop table if exists per_attend_card_record;
drop table if exists per_task_card_record;




drop table if exists `tb_attend`;
CREATE TABLE `tb_attend` (
  `id` bigint(20) NOT NULL COMMENT '考勤套ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `attendName` varchar(200) DEFAULT NULL COMMENT '名称',
  `active` char(1) DEFAULT '1' COMMENT '是否启用 1是0否',
  `outLimit` char(1) DEFAULT NULL COMMENT '是否限制外出跨月 1是0否',
  `clockType` char(1) DEFAULT NULL COMMENT '打卡类型 0定位1wifi',
  `face` char(1) DEFAULT NULL COMMENT '是否开启人脸认证 1是0否',
  `position` char(1) DEFAULT NULL COMMENT '是否开启定位打卡 1是0否',
  `longitude` double DEFAULT NULL COMMENT '定位经度',
  `latitude` double DEFAULT NULL COMMENT '定位纬度',
  `address` varchar(500) DEFAULT NULL COMMENT '定位地址',
  `validRange` int(8) DEFAULT NULL COMMENT '定位有效范围',
  `wifi` char(1) DEFAULT NULL COMMENT '是否开启WIFI打卡 1是0否',
  `wifiName` varchar(200) DEFAULT NULL COMMENT 'wifi名称',
  `wifiMac` varchar(50) DEFAULT NULL COMMENT 'wifi设备mac地址',
  `countLimit` int(8) DEFAULT NULL COMMENT '补卡次数限制',
  `leaveLimit` char(1) DEFAULT NULL COMMENT '是否限制请假跨月 1是0否',
  `overRemind` char(1) DEFAULT NULL COMMENT '是否开启假别超支提醒 1是0否',
  `sameLimit` char(1) DEFAULT NULL COMMENT '同假别的请假单是否允许同时提交 1是0否',
  `minUnit` varchar(20) DEFAULT NULL COMMENT '最小加班单位',
  `clockIn` char(1) DEFAULT NULL COMMENT '加班开始,结束是否要刷卡 1是0否',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤套';


drop table if exists `tb_attend_charge`;
CREATE TABLE `tb_attend_charge` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '考勤套负责人ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime DEFAULT NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '负责人ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤套负责人';



drop table if exists `tb_attend_shift`;
CREATE TABLE `tb_attend_shift` (
  `id` bigint(20) NOT NULL COMMENT '考勤班次ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `active` char(1) DEFAULT '1' COMMENT '是否启用 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `shiftName` varchar(200) DEFAULT NULL COMMENT '班次名称',
  `startTime` varchar(10) DEFAULT NULL COMMENT '上班时间',
  `endTime` varchar(10) DEFAULT NULL COMMENT '下班时间',
  `crossDay` char(1) DEFAULT '0' COMMENT '是否跨天 1是0否',
  `shiftHour` double DEFAULT NULL COMMENT ' 班次总时长',
  `needRest` char(1) DEFAULT '1' COMMENT '是否休息 1是0否',
  `restStart` varchar(10) DEFAULT NULL COMMENT '休息开始时间',
  `restEnd` varchar(10) DEFAULT NULL COMMENT '休息结束时间',
  `restHour` double DEFAULT NULL COMMENT ' 休息时长',
  `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤班次';


drop table if exists `tb_attend_per`;
CREATE TABLE `tb_attend_per` (
  `id` bigint(20) NOT NULL COMMENT '考勤人员ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
#   `needCalendar` char(1) DEFAULT '1' COMMENT '是否使用休息日套 1是0否',
#   `calendarId` bigint(20) DEFAULT NULL COMMENT '日历套ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤人员';


drop table if exists `tb_attend_schedul`;
CREATE TABLE `tb_attend_schedul` (
  `id` bigint(20) NOT NULL COMMENT '排班ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  `needCalendar` char(1) DEFAULT '1' COMMENT '是否使用休息日套 1是0否',
  `calendarId` bigint(20) DEFAULT NULL COMMENT '日历套ID',
  `shiftIds` text DEFAULT NULL COMMENT '班次IDs',
  `perIds` text DEFAULT NULL COMMENT '人员IDs',
  `startDate` varchar(20) DEFAULT NULL COMMENT '上班日期',
  `endDate` varchar(20) DEFAULT NULL COMMENT '上班日期',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤排班';

drop table if exists `tb_attend_schedul_detail`;
CREATE TABLE `tb_attend_schedul_detail` (
  `id` bigint(20) NOT NULL COMMENT '排班详情ID',
  `schedulId` bigint(20) NOT NULL COMMENT '排班ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `needCalendar` char(1) DEFAULT '1' COMMENT '是否使用休息日套 1是0否',
  `calendarId` bigint(20) DEFAULT NULL COMMENT '日历套ID',
  `shiftId` bigint(20) DEFAULT NULL COMMENT '班次ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
  `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `attendId` bigint(20) DEFAULT NULL COMMENT '考勤套ID',
  `schedulDate` varchar(20) DEFAULT NULL COMMENT '上班日期',
  `startTime` varchar(20) DEFAULT NULL COMMENT '上班时间',
  `endTime` varchar(20) DEFAULT NULL COMMENT '下班时间',
  `needRest` char(1) DEFAULT '1' COMMENT '是否休息 1是0否',
  `restStart` varchar(20) DEFAULT NULL COMMENT '休息开始时间',
  `restEnd` varchar(20) DEFAULT NULL COMMENT '休息结束时间',
  `schedulType` char(2) DEFAULT NULL COMMENT '类型 0休息 1上班',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤排班详情';

drop table if exists `tb_attend_dict`;
CREATE TABLE `tb_attend_dict` (
  `id` bigint(20) NOT NULL COMMENT '类别ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `dictName` varchar(200) DEFAULT NULL COMMENT '名称',
  `dictType` char(2) DEFAULT NULL COMMENT '类别 0请假1加班2公出',
  `active` char(1) DEFAULT '1' COMMENT '是否启用 1是0否',
  `annex` char(1) DEFAULT NULL COMMENT '是否必须上传附件 0非必须 1必须',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤字典类别';



drop table if exists `tb_attend_calendar`;
CREATE TABLE `tb_attend_calendar` (
  `id` bigint(20) NOT NULL COMMENT '日历套ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `calendarName` varchar(200) DEFAULT NULL COMMENT '日历套名称',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
#   `attendId` bigint(20) NOT NULL COMMENT '考勤套ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡日历套';


drop table if exists `tb_attend_calendar_rest`;
CREATE TABLE `tb_attend_calendar_rest` (
  `id` bigint(20) NOT NULL COMMENT '日历ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `calendarType` char(2) DEFAULT NULL COMMENT '日历类型',
  `startDate` varchar(20) DEFAULT NULL COMMENT '开始日期',
  `endDate` varchar(20) DEFAULT NULL COMMENT '结束日期',
  `calendarId` bigint(20) NOT NULL COMMENT '日历套ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡日历套-日历';

drop table if exists `tb_attend_calendar_rest_detail`;
CREATE TABLE `tb_attend_calendar_rest_detail` (
 `id` bigint(20) NOT NULL COMMENT '休息日ID',
 `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
 `createTime` datetime NULL COMMENT '创建时间',
 `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
 `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
 `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
 `calendarType` char(2) DEFAULT NULL COMMENT '日历类型',
 `restDate` varchar(20) DEFAULT NULL COMMENT '日期',
 `restId` bigint(20) NOT NULL COMMENT '日历ID',
 `calendarId` bigint(20) NOT NULL COMMENT '日历套ID',
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡日历套-日历-休息日';


drop table if exists `tb_attend_clock`;
CREATE TABLE `tb_attend_clock` (
 `schedulDetailId` bigint(20) NOT NULL COMMENT '排班详情ID',
 `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
 `createTime` datetime NULL COMMENT '创建时间',
 `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
 `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
 `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
 `clockStart` varchar(20) DEFAULT NULL COMMENT '上班打卡时间',
 `clockEnd` varchar(20) DEFAULT NULL COMMENT '下班打卡时间',
 `clockSource` varchar(2) DEFAULT NULL COMMENT '数据来源 1打卡2补卡3手动补卡',
 `clockStatus` varchar(2) DEFAULT NULL COMMENT '打卡状态 0缺勤1正常2缺卡3迟到4早退5请假6补卡21上班缺卡22下班缺卡61上班补卡62下班补卡',
 `leaveEarly` int(8) DEFAULT NULL COMMENT '早退分钟数',
 `lateMin` int(8) DEFAULT NULL COMMENT '迟到分钟数',
 `workHour` double DEFAULT NULL COMMENT '实际出勤时数',
 `absenteeism` double DEFAULT NULL COMMENT '旷工时数',
 `missCard` int(8) DEFAULT NULL COMMENT '漏卡次数',
 `leaveHour` double DEFAULT NULL COMMENT '请假时数',
 `businessOut` double DEFAULT NULL COMMENT '公出时数',
 `businessTrip` double DEFAULT NULL COMMENT '出差时数',
 `address` varchar(200) DEFAULT NULL COMMENT '打卡地址',
 `wifiName` varchar(200) DEFAULT NULL COMMENT '打卡wifi名称',
 `reason` varchar(500) DEFAULT NULL COMMENT '补卡原因',
 `remark` varchar(500) DEFAULT NULL COMMENT '备注',
 PRIMARY KEY (`schedulDetailId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡记录';


# drop table if exists `tb_attend_clock_result`;
# CREATE TABLE `tb_attend_clock_result` (
#  `schedulDetailId` bigint(20) NOT NULL COMMENT '排班详情ID',
#  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
#  `createTime` datetime NULL COMMENT '创建时间',
#  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
#  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
#  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
#  `resultStart` varchar(20) DEFAULT NULL COMMENT '上班打卡时间',
#  `resultEnd` varchar(20) DEFAULT NULL COMMENT '下班打卡时间',
#  `leaveEarly` int(8) DEFAULT NULL COMMENT '早退分钟数',
#  `lateMin` int(8) DEFAULT NULL COMMENT '迟到分钟数',
#  `workHour` double DEFAULT NULL COMMENT '实际出勤时数',
#  `absenteeism` double DEFAULT NULL COMMENT '旷工时数',
#  `missCard` int(8) DEFAULT NULL COMMENT '漏卡次数',
#  `leaveHour` double DEFAULT NULL COMMENT '请假时数',
#  `businessOut` double DEFAULT NULL COMMENT '公出时数',
#  `overtime` double DEFAULT NULL COMMENT '加班时数',
#  `businessTrip` double DEFAULT NULL COMMENT '出差时数',
#  `resultStatus` varchar(2) DEFAULT NULL COMMENT '打卡状态 0缺勤1正常2缺卡3迟到4早退5请假6补卡21上班缺卡22下班缺卡61上班补卡62下班补卡',
#  `remark` varchar(500) DEFAULT NULL COMMENT '备注',
#  PRIMARY KEY (`schedulDetailId`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡记录结果统计';


drop table if exists `tb_attend_clock_detail`;
CREATE TABLE `tb_attend_clock_detail` (
 `id` bigint(20) NOT NULL COMMENT '考勤打卡详情ID',
 `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
 `createTime` datetime NULL COMMENT '创建时间',
 `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
 `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
 `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
 `schedulDetailId` bigint(20) DEFAULT NULL COMMENT '排班详情ID',
 `longitude` double DEFAULT NULL COMMENT '打卡定位经度',
 `latitude` double DEFAULT NULL COMMENT '打卡定位纬度',
 `address` varchar(200) DEFAULT NULL COMMENT '打卡地址',
 `wifiName` varchar(200) DEFAULT NULL COMMENT '打卡wifi名称',
 `wifiMac` varchar(50) DEFAULT NULL COMMENT '打卡wifi设备mac地址',
 `clockTime` datetime DEFAULT NULL COMMENT '打卡时间',
 `clockType` char(2) DEFAULT NULL COMMENT '打卡类型1上班2下班',
 `remark` varchar(500) DEFAULT NULL COMMENT '备注',
 PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤打卡记录-详情';

drop table if exists `tb_attend_report`;
CREATE TABLE `tb_attend_report` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '报表ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
  `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `reportDate` varchar(20) DEFAULT NULL COMMENT '日期',
  `attendReportType` varchar(2) DEFAULT NULL COMMENT '报表类型 1日报 2月报',
  `attendResultStatus` varchar(2) DEFAULT NULL COMMENT '结果状态 0缺勤1正常2缺卡3迟到4早退',
  `shiftHour` double DEFAULT NULL COMMENT '应出勤时数',
  `workHour` double DEFAULT NULL COMMENT '实际出勤时数',
  `workCount` int(8) DEFAULT NULL COMMENT '出勤天数',
  `restCount` int(8) DEFAULT NULL COMMENT '休息天数',
  `absenteeism` double DEFAULT NULL COMMENT '旷工时数',
  `leaveEarly` int(8) DEFAULT NULL COMMENT '早退分钟数',
  `leaveEarlyCount` int(8) DEFAULT NULL COMMENT '早退次数',
  `lateMin` int(8) DEFAULT NULL COMMENT '迟到分钟数',
  `lateCount` int(8) DEFAULT NULL COMMENT '迟到次数',
  `missCard` int(8) DEFAULT NULL COMMENT '漏卡次数',
  `leaveHour` double DEFAULT NULL COMMENT '请假时数',
  `businessOut` double DEFAULT NULL COMMENT '公出时数',
  `overtime` double DEFAULT NULL COMMENT '加班时数',
  `businessTrip` double DEFAULT NULL COMMENT '出差时数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤结果统计';


drop table if exists `tb_attend_leave`;
CREATE TABLE `tb_attend_leave` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '请假统计ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `oaLeaveId` varchar(200) DEFAULT NULL COMMENT '请假ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
  `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
  `schedulDetailId` bigint(20) DEFAULT NULL COMMENT '排班详情ID',
  `leaveDate` varchar(20) DEFAULT NULL COMMENT '请假日期',
  `leaveType` varchar(20) DEFAULT NULL COMMENT '请假类型',
  `leaveHour` double DEFAULT NULL COMMENT '请假时长',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤请假统计';


# drop table if exists `tb_attend_card`;
# CREATE TABLE `tb_attend_card` (
#  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '补卡ID',
#  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
#  `createTime` datetime NULL COMMENT '创建时间',
#  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
#  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
#  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
#  `perId` bigint(20) DEFAULT NULL COMMENT '人员ID',
#  `deptId` bigint(20) DEFAULT NULL COMMENT '部门ID',
#  `comId` bigint(20) DEFAULT NULL COMMENT '公司ID',
#  `schedulDetailId` bigint(20) DEFAULT NULL COMMENT '排班详情ID',
#  `cardTime` datetime DEFAULT NULL COMMENT '补卡时间',
#  `reason` varchar(500) DEFAULT NULL COMMENT '补卡原因',
#  PRIMARY KEY (`id`)
# ) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='考勤补卡';


drop table if exists `tb_attend_change_shift`;
CREATE TABLE `tb_attend_change_shift` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '换班记录ID',
  `isDelete` char(1) DEFAULT '0' COMMENT '是否删除 1是0否',
  `createTime` datetime NULL COMMENT '创建时间',
  `createBy` bigint(20) DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updateBy` bigint(20) DEFAULT NULL COMMENT '修改人ID',
  `perId` bigint(20) DEFAULT NULL COMMENT '换班申请人ID',
  `schedulDate` varchar(20) DEFAULT NULL COMMENT '换班申请人上班日期',
  `schedulDetailIds` varchar(500) DEFAULT NULL COMMENT '排班ids',
  `changePerId` bigint(20) DEFAULT NULL COMMENT '被换班人ID',
  `changeDate` varchar(20) DEFAULT NULL COMMENT '换班日期',
  `changeSchedulDetailIds` varchar(500) DEFAULT NULL COMMENT '被换班人排班ids',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='换班记录';


######2021-11-09
ALTER TABLE `tb_attend`
  ADD COLUMN `shiftType`  char(1) NULL DEFAULT '1' COMMENT '班次类型 1计时班次 2 计次班次' AFTER `active`;
ALTER TABLE `tb_attend_shift`
  ADD COLUMN `shiftType`  char(1) NULL DEFAULT '1' COMMENT '班次类型 1计时班次 2 计次班次' AFTER `active`;
ALTER TABLE `tb_attend_clock`
  ADD COLUMN `shiftType`  char(1) NULL DEFAULT '1' COMMENT '班次类型 1计时班次 2 计次班次';


ALTER TABLE `tb_attend_report`
  ADD COLUMN `minShiftType`  char(1) NULL DEFAULT '1' COMMENT '班次类型 1计时班次 2 计次班次';
ALTER TABLE `tb_attend_report`
  ADD COLUMN `maxShiftType`  char(1) NULL DEFAULT '1' COMMENT '班次类型 1计时班次 2 计次班次';


ALTER TABLE `tb_attend_report`
  ADD COLUMN `shiftNum`  int NULL COMMENT '应出勤次数' AFTER `workHour`,
  ADD COLUMN `workNum`  int NULL COMMENT '实际出勤次数' AFTER `shiftNum`;

ALTER TABLE `tb_attend`
  ADD COLUMN `deptId`  bigint(20) NULL AFTER `comId`;
ALTER TABLE `tb_attend_calendar`
  ADD COLUMN `deptId`  bigint(20) NULL AFTER `comId`;

update tb_attend t1,per_org_relation t2
set t1.deptId = t2.orgId
where t1.createBy= t2.perId and t1.deptId is null;


update tb_attend_calendar t1,per_org_relation t2
set t1.deptId = t2.orgId
where t1.createBy= t2.perId and t1.deptId is null;
