package com.bcxin.platform.web.controller.product;

import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.service.product.ProductCouponService;
import com.bcxin.platform.util.log.Log;
import com.bcxin.platform.web.controller.base.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 产品优惠券的controller层
 * by llc 2020-12-16
 */
@RestController
@RequestMapping("/product/coupon")
@Api(tags = { "" }, description = "产品优惠券管理")
public class CouponController extends BaseController {

	@Autowired
	private ProductCouponService productCouponService;

	/**
	 * 校验优惠券
	 * @return
	 * @author llc
	 * @date 2020-12-16
	 */
	@Log(operation = Log.OPERA_TYPE_SELECT, modle = "校验优惠券", title = "校验优惠券", systemType = Log.SYSTEMTYPE_PHONE)
	@ApiOperation(value = "校验优惠券", httpMethod = "POST", notes = "校验优惠券", response = Result.class)
	@PostMapping(value = "check-product-coupon")
	public Result checkProductCoupon(ProductCoupon productCoupon) {
		CurrentUser currentUser = new CurrentUser(getRequest());
		if (currentUser.getPerId() == null) {
			return Result.tokenExpired("用户登录超时或者未登录").setBack(getRequest());
		}
		return productCouponService.checkProductCoupon(productCoupon).setBack(getRequest());
	}


}
