package com.bcxin.platform.web.controller.attend;

import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.poi.ExcelUtil;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.attend.AttendShiftDto;
import com.bcxin.platform.service.attend.AttendShiftService;
import com.bcxin.platform.service.company.PerOrgRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 考勤班次Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/attend/shift")
public class AttendShiftController extends BaseController{


    @Autowired
    private AttendShiftService attendShiftService;

    @Autowired
    private PerOrgRelationService perOrgRelationService;

    /**
     * 查询考勤班次列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendShiftDto attendShift){
        attendShift.setActive(Constants.Y);
        List<AttendShiftDto> list = attendShiftService.selectList(attendShift);
        return getDataTable(list);
    }

    /**
     * 查询考勤班次列表
     */
    @PostMapping("/searchForPage")
    public TableDataInfo searchForPage(AttendShiftDto attendShift){
        startPage();
        List<AttendShiftDto> list = attendShiftService.selectList(attendShift);
        return getDataTable(list);
    }

    /**
     * 导出考勤班次列表
     */
    @Log(title = "考勤班次", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public AjaxResult export(AttendShiftDto attendShift){
        List<AttendShiftDto> list = attendShiftService.selectList(attendShift);
        ExcelUtil<AttendShiftDto> util = new ExcelUtil<AttendShiftDto>(AttendShiftDto.class);
        return util.exportExcel(list, "shift");
    }

    /**
     * 导入考勤班次
     */
    @Log(title = "考勤班次", businessType = BusinessType.IMPORT)
    @PostMapping("/import")
    public AjaxResult importData(MultipartFile file, Long attendId){
        try {
            if(attendId == null){
                return AjaxResult.error("考勤套不能为空");
            }
            CurrentUser currentUser = new CurrentUser(getRequest());
            ExcelUtil<AttendShift> util = new ExcelUtil<AttendShift>(AttendShift.class);
            List<AttendShift> shiftList = util.importExcel(file.getInputStream());

            PerOrgRelation perOrgRelation = perOrgRelationService.findByPerId(currentUser.getPerId());
            for (AttendShift attendShift : shiftList) {
                attendShiftService.validateData(attendShift);
                attendShift.setActive(Constants.Y);
                attendShift.setDeptId(perOrgRelation.getOrgId());
                attendShift.setComId(currentUser.getComId());
                attendShift.setAttendId(attendId);
                attendShift.setCreateBy(currentUser.getPerId().toString());
                attendShift.setUpdateBy(currentUser.getPerId().toString());
            }
            attendShiftService.saveBatch(shiftList);
        }catch (Exception e){
            return AjaxResult.error("导入失败："+e.getMessage());
        }
        return AjaxResult.success("导入成功！");
    }

    /**
     * 根据id查询考勤班次
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        AttendShift attendShift = attendShiftService.findById(id);
        return AjaxResult.success(null,attendShift);
    }

    /**
     * 保存考勤班次
     */
    @Log(title = "考勤班次", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(AttendShift attendShift){
        return toAjax(attendShiftService.update(attendShift));
    }

    /**
     * 删除考勤班次
     */
    @Log(title = "考勤班次", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendShiftService.deleteByIds(ids));
    }

}
