package com.bcxin.platform.web.controller.app.attend;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.annotation.Log;
import com.bcxin.platform.common.core.controller.BaseController;
import com.bcxin.platform.common.core.domain.AjaxResult;
import com.bcxin.platform.common.core.page.TableDataInfo;
import com.bcxin.platform.common.enums.BusinessType;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.validator.ValidatorUtils;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.domain.attend.Attend;
import com.bcxin.platform.dto.CurrentUser;
import com.bcxin.platform.dto.app.AppAttendDto;
import com.bcxin.platform.dto.app.AppAttendEditDto;
import com.bcxin.platform.dto.app.AppAttendManageDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendDto;
import com.bcxin.platform.dto.attend.AttendSchedulPerDto;
import com.bcxin.platform.dto.company.ComDepartDto;
import com.bcxin.platform.service.attend.AttendSchedulService;
import com.bcxin.platform.service.attend.AttendService;
import com.bcxin.platform.service.company.ComDepartService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 考勤套Controller
 * 
 * @author lin
 * @date 2021-08-10
 */
@RestController
@RequestMapping("/app/attend")
public class AppAttendController extends BaseController{

    @Autowired
    private AttendService attendService;

    @Autowired
    private AttendSchedulService attendSchedulService;

    @Autowired
    private ComDepartService comDepartService;

    /**
     * 获取当前用户负责的考勤套列表
     */
    @PostMapping("/list")
    public TableDataInfo list(AttendDto attend){
        List<Attend> list = attendService.selectListForChargePer(attend);
        return getDataTable(list);
    }

    /**
     * 获取当前用户负责管理的考勤套列表
     */
    @PostMapping("/manage/list")
    public TableDataInfo manageList(AttendDto attend){
        List<AppAttendManageDto> list = attendService.selectManageListForChargePer(attend);
        return getDataTable(list);
    }

    /**
     * 保存考勤套
     */
    @Log(title = "考勤套", businessType = BusinessType.UPDATE)
    @PostMapping("/save")
    public AjaxResult editSave(@RequestBody AppAttendEditDto attend){
        ValidatorUtils.validateEntity(attend, AddGroup.class);
        return toAjax(attendService.updateForApp(attend));
    }

    /**
     * 删除考勤套
     */
    @Log(title = "考勤套", businessType = BusinessType.DELETE)
    @PostMapping( "/remove")
    public AjaxResult remove(String ids){
        return toAjax(attendService.deleteByIds(ids));
    }


    /**
     * 查询考勤套
     */
    @GetMapping("/findById/{id}")
    public AjaxResult findById(@PathVariable("id") Long id){
        Attend attend = attendService.findById(id);
        return AjaxResult.success(attend);
    }
    /**
     * 获取当前考勤套
     */
    @GetMapping("/getCurrent")
    public AjaxResult getCurrent(AppAttendSearchDto searchDto){
        CurrentUser currentUser = new CurrentUser(getRequest());
        searchDto.setPerId(currentUser.getPerId());
        if(StrUtil.isEmpty(searchDto.getSchedulDate())){
            searchDto.setSchedulDate(DateUtils.getDate());
        }
        AppAttendDto attend = attendService.findByPerId(searchDto);
        if(attend != null) {
            return AjaxResult.success(attend);
        }

        return AjaxResult.error("无相关考勤套");
    }


    /**
     * 选人公共部门树接口
     * @param comDepart
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @PostMapping(value = "getTreeDepart")
    public AjaxResult getTreeDepart(ComDepartDto comDepart) {
        CurrentUser currentUser = new CurrentUser(getRequest());
        comDepart.setPerID(currentUser.getPerId());
        return AjaxResult.success(null,comDepartService.getTreeDepartForAttend(comDepart));
    }

    /**
     * 获取选人公共部门树的人员列表
     * @param searchDto
     * @auth llc
     * @date 2019-08-28
     * @return
     */
    @PostMapping(value = "getDepartPersonList")
    public AjaxResult getDepartPersonList(AttendSchedulPerDto searchDto) {
        return AjaxResult.success(null,attendSchedulService.getDepartPersonList(searchDto));
    }

}
