package com.bcxin.platform.service.blb;


import com.bcxin.platform.common.utils.Result;

/**
 * <b> 百联保联调 </b>
 * @author ZXF
 * @create 2020/03/20 0020 16:45
 * @version
 * @注意事项 </b>
 */
public interface BlbTestService {

    /**
     * <b> 做增员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    Result blbAddPreservationService(String comId, String orderId, String listStr, String inceptionDate);

    /**
     * <b> 做减员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    Result blbMinusPreservationService(String comId, String orderId, String listStr,String inceptionDate);

    /**
     * <b> 在保未录入列表人员做减员保全 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    Result blbMinusPreservationByNotIncluded(String comId, String orderId, String listStr,String inceptionDate);

    /**
     * <b> 用户信息添加到缓存，返回生成的百联保访问地址 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getCompnayAndPersonPutCacheUrl(String reviseType, String cacheId);

    /**
     * <b> 已投保未录入人员身份证去百联保匹配获取姓名 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    Result blbPerName(String listStr);

    /**
     * <b> 订单列表页面链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbOrderPageLinkUrl(String businessType);

    /**
     * <b> 理赔列表页面链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbReportPageLinkUrl();

    /**
     * <b> 保全页面链接生成，不带人员信息 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbPreservationPageLinkUrl();

    /**
     * <b> 在线企业保险链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String blbLinkUrl(Long comId, String login_name);

    /**
     * <b> 在线企业保险用户激活链接生成 </b>
     * @author ZXF
     * @create 2021/02/23 0023 13:24
     * @version
     * @注意事项 </b>
     */
    String blbActivateUserLinkUrl(Long comId, String login_name);

    /**
     * <b> 企业保险详情链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbDetailLinkUrl(String orderId);

    /**
     * <b> 企业保全列表的保险详情链接生成 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbPreservationLinkUrl(String reviseType, String orderId, String cacheId);

    /**
     * <b> 获得百联保保险产品列表 </b>
     * @author ZXF
     * @create 2020/03/20 0020 17:49
     * @version
     * @注意事项 </b>
     */
    String getBlbProList();

    /**
     * <b> 获取保单号对应的在保人数 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:33
     * @version
     * @注意事项 </b>
     */
    Result blbZBNum(String token,String policyNos);

    /**
     * <b> 线下保单如果标识百联保购买就去百联保对应订单打上标识 </b>
     * @author ZXF
     * @create 2020/04/20 0020 10:33
     * @version
     * @注意事项 </b>
     */
    Result blbSetSign(String token,String policyNo,String webType);

    /**
     * <b> 通用生成百联保接口地址，带token </b>
     * @author ZXF
     * @create 2020/06/29 0029 14:51
     * @version
     * @注意事项 </b>
     */
    String blbLinkUrl(Long comId, String loginName, String urlBody);

    /**
     * <b> APP理赔列表 </b>
     * @param idCardNo 身份证
     * @param status 理赔状态
     * @author ZXF
     * @create 2020/06/29 0029 15:04
     * @version
     * @注意事项 </b>
     */
    String reportList(String idCardNo,String status, Long comId);

    /**
     * <b> 根据身份证查询有过参与投保的保单记录 </b>
     * @author ZXF
     * @create 2020/06/29 0029 18:07
     * @version
     * @注意事项 </b>
     */
    String findPolicyByIdCard(String idCardNo, Long comId);

    /**
     * <b> APP理赔详情 </b>
     * @param reportId 理赔记录Id
     * @author ZXF
     * @create 2020/06/29 0029 15:06
     * @version
     * @注意事项 </b>
     */
    String getReportById(String reportId,Long comId);

    /**
     * <b> 提交报案信息 </b>
     * @author ZXF
     * @create 2020/06/29 0029 15:23
     * @version
     * @注意事项 </b>
     */
    String saveReport(Long comId);

    /**
     * <b> 报案理流程附件补传 </b>
     * @author ZXF
     * @create 2020/06/29 0029 15:23
     * @version
     * @注意事项 </b>
     */
    String saveUploadFile(Long comId);

    /**
     * <b> 通过图片地址上传到平安ibos平台，激活fileId并返回 </b>
     * @author ZXF
     * @create 2020/06/29 0029 16:35
     * @version
     * @注意事项 </b>
     */
    String getFileIdByPath(String path, Long comId);
}