package com.bcxin.platform.service.attend.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.oaflow.domain.MakeUpCard;
import com.bcxin.oaflow.dto.MakeUpCardDto;
import com.bcxin.oaflow.mapper.MakeUpCardMapper;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.constant.DictConst;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.domain.attend.AttendClockDetail;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.domain.attend.AttendShift;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendClockStateDto;
import com.bcxin.platform.mapper.attend.*;
import com.bcxin.platform.service.attend.AttendClockService;
import com.bcxin.platform.timer.AttendReportTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 考勤打卡记录Service业务层处理
 * 
 * @author lin
 * @date 2021-08-27
 */
@Service
@Transactional("transactionManager")
public class AttendClockServiceImpl implements AttendClockService{

    @Autowired
    private AttendSchedulDetailMapper attendSchedulMapper;

    @Autowired
    private AttendClockMapper attendClockMapper;

    @Autowired
    private AttendClockDetailMapper attendClockDetailMapper;

    @Autowired
    private MakeUpCardMapper makeUpCardMapper;

    @Autowired
    private AttendReportMapper attendReportMapper;

    @Autowired
    private AttendShiftMapper attendShiftMapper;

    @Resource
    private IdWorker idWorker;

    @Resource
    private AttendReportTask attendReportTask;

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    @Override
    public AttendClock findById(Long id){
        return attendClockMapper.findById(id);
    }

    /**
     * 查询考勤打卡记录列表
     * 
     * @param searchDto 考勤打卡记录
     * @return 考勤打卡记录
     */
    @Override
    public List<AttendClockDto> selectList(AttendClockDto searchDto){
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendClockMapper.selectList(searchDto);
    }

    /**
     * 修改考勤打卡记录
     * 
     * @param attendClock 考勤打卡记录
     * @return 结果
     */
    @Override
    public int update(AttendClock attendClock){

        AttendClock dbAttendClock = attendClockMapper.findById(attendClock.getSchedulDetailId());
        if(dbAttendClock == null){
            attendClock.setCreateTime(DateUtils.getNowDate());
            attendClock.setIsDelete(Constants.N);
        }else{
            //if(StrUtil.isNotEmpty(attendClock.getClockStart())){
            //    Date newDate = DateUtils.parseDate(DateUtils.getDate()+" " + attendClock.getClockStart());
            //    Date oldDate = DateUtils.parseDate(DateUtils.getDate()+" " + dbAttendClock.getClockStart());
            //    if(newDate.getTime()>oldDate.getTime()){
            //        attendClock.setClockStart(dbAttendClock.getClockStart());
            //    }
            //}
            attendClock.setClockStart(dbAttendClock.getClockStart());
            BeanUtils.copyPropertiesIgnore(attendClock,dbAttendClock,true);
            BeanUtils.copyPropertiesIgnore(dbAttendClock,attendClock,false);
        }


        AttendSchedulDetail attendSchedul = attendSchedulMapper.findById(attendClock.getSchedulDetailId());
        //休息分钟数
        Integer restMinu = 0;
        if(Constants.Y.equals(attendSchedul.getNeedRest())) {
            restMinu = DateUtils.minDiff(attendSchedul.getRestStart(), attendSchedul.getRestEnd()).intValue();
        }

        //计算迟到分钟数
        Integer lateMin = 0;
        if(attendClock.getLateMin() == null && StrUtil.isNotEmpty(attendClock.getClockStart())){
            Date startTime = DateUtils.parseDate(attendSchedul.getStartTime());
            Date endTime = DateUtils.parseDate(attendClock.getClockStart());

            if(startTime.getTime()<endTime.getTime()) {
                Integer actualRestMinu = 0;
                //与休息时间比对
                if (Constants.Y.equals(attendSchedul.getNeedRest())) {
                    Date restStart = DateUtils.parseDate(attendSchedul.getRestStart());
                    Date restEnd = DateUtils.parseDate(attendSchedul.getRestEnd());

                    if (endTime.getTime() > restStart.getTime() && endTime.getTime() < restEnd.getTime()) {
                        //打卡时间在休息时间段内，则计算迟到结束时间以休息开始时间为准
                        endTime = restStart;
                    } else if (endTime.getTime() >= restStart.getTime()) {
                        actualRestMinu = restMinu;
                    }
                }
                lateMin = DateUtils.minDiff(startTime, endTime).intValue() - actualRestMinu;
                if (lateMin > 0) {
                    attendClock.setClockStatus(DictConst.CLOCKSTATUS_3);
                }
            }
            //迟到分钟数
            attendClock.setLateMin(lateMin);
        }


        if(DictConst.SHIFTTYPE_JSBC.equals(attendClock.getShiftType())) {
            //计算早退分钟数
            Integer leaveEarly = 0;
            if (attendClock.getLeaveEarly() == null && StrUtil.isNotEmpty(attendClock.getClockEnd())) {
                Date startTime = DateUtils.parseDate(attendClock.getClockEnd());
                Date endTime = DateUtils.parseDate(attendSchedul.getEndTime());

                if (startTime.getTime() < endTime.getTime()) {
                    Integer actualRestMinu = 0;
                    //与休息时间比对
                    if (Constants.Y.equals(attendSchedul.getNeedRest())) {
                        Date restStart = DateUtils.parseDate(attendSchedul.getRestStart());
                        Date restEnd = DateUtils.parseDate(attendSchedul.getRestEnd());
                        if (startTime.getTime() > restStart.getTime() && startTime.getTime() < restEnd.getTime()) {
                            //打卡时间在休息时间段内，则计算早退开始时间以休息结束时间为准
                            startTime = restEnd;
                        } else if (endTime.getTime() <= restStart.getTime()) {
                            actualRestMinu = restMinu;
                        }
                    }
                    leaveEarly = DateUtils.minDiff(startTime, endTime).intValue() - actualRestMinu;
                    if (leaveEarly > 0) {
                        if (DictConst.CLOCKSTATUS_3.equals(attendClock.getClockStatus())) {
                            attendClock.setClockStatus(DictConst.CLOCKSTATUS_34);
                        } else {
                            attendClock.setClockStatus(DictConst.CLOCKSTATUS_4);
                        }
                    }
                }
                //早退分钟数
                attendClock.setLeaveEarly(leaveEarly);
            }

            //漏打上班卡
            if (StrUtil.isEmpty(attendClock.getClockStart())) {
                attendClock.setClockStatus(DictConst.CLOCKSTATUS_21);
                if (leaveEarly > 0) {
                    attendClock.setClockStatus(DictConst.CLOCKSTATUS_24);
                }
            }

            if (StrUtil.isEmpty(attendClock.getClockStatus()) && StrUtil.isNotEmpty(attendClock.getClockStart()) && StrUtil.isNotEmpty(attendClock.getClockEnd())) {
                attendClock.setClockStatus(DictConst.CLOCKSTATUS_1);
            }
        }else{
            if (StrUtil.isEmpty(attendClock.getClockStatus()) && StrUtil.isNotEmpty(attendClock.getClockStart())) {
                attendClock.setClockStatus(DictConst.CLOCKSTATUS_1);
            }
        }

        attendClock.setUpdateTime(DateUtils.getNowDate());
        return attendClockMapper.save(attendClock);
    }

    @Override
    public int saveClock(AttendClockDetail attendClockDetail) {
        if(attendClockDetail.getId() == null){
            attendClockDetail.setCreateTime(DateUtils.getNowDate());
            attendClockDetail.setId(idWorker.nextId());
            attendClockDetail.setIsDelete(Constants.N);
        }else{
            AttendClockDetail dbAttendClockDetail = attendClockDetailMapper.findById(attendClockDetail.getId());
            BeanUtils.copyPropertiesIgnore(attendClockDetail,dbAttendClockDetail,true);
            BeanUtils.copyPropertiesIgnore(dbAttendClockDetail,attendClockDetail,false);
        }
        //TODO 正式此处不注释
        attendClockDetail.setClockTime(DateUtils.getNowDate());
        attendClockDetail.setUpdateTime(DateUtils.getNowDate());

        AttendClock attendClock =attendClockMapper.findById(attendClockDetail.getSchedulDetailId());
        if(attendClock == null){
            attendClock = new AttendClock();
        }

        BeanUtils.copyPropertiesIgnore(attendClockDetail,attendClock,true);
        AttendSchedulDetail attendSchedulDetail = attendSchedulMapper.findById(attendClockDetail.getSchedulDetailId());
        AttendShift attendShift = attendShiftMapper.findById(attendSchedulDetail.getShiftId());
        attendClock.setShiftType(attendShift.getShiftType());
        if(DictConst.SHIFTTYPE_JSBC.equals(attendClock.getShiftType())) {
            if (StrUtil.isEmpty(attendClock.getClockStart())) {
                if (DateUtils.parseDate(attendSchedulDetail.getEndTime()).getTime() < DateUtils.getNowDate().getTime()) {
                    attendClock.setClockEnd(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM, attendClockDetail.getClockTime()));
                } else {
                    attendClock.setClockStart(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM, attendClockDetail.getClockTime()));
                }
            } else {
                attendClock.setClockEnd(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM, attendClockDetail.getClockTime()));
            }
        }else{
            attendClock.setClockStart(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM, attendClockDetail.getClockTime()));
        }

        //if(DictConst.CLOCKTYPE_SB.equals(attendClockDetail.getClockType())){
        //    attendClock.setClockStart(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,attendClockDetail.getClockTime()));
        //}else{
        //    attendClock.setClockEnd(DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD_HH_MM,attendClockDetail.getClockTime()));
        //}
        //数据来源 打卡
        attendClock.setClockSource(DictConst.CLOCKSOURCE_DK);

        update(attendClock);

        return attendClockDetailMapper.save(attendClockDetail);
    }

    /**
     * 删除考勤打卡记录对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids) {
        return attendClockMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 管理员操作补卡
     *
     * @param clockDetailDto 需要补卡的数据
     * @return 结果
     */
    @Override
    public int updateState(AttendClockStateDto clockDetailDto){
        List<AttendClock> clockList = attendClockMapper.findByIds(Convert.toStrArray(clockDetailDto.getIds()));
        if(clockList.size() == 0){
            throw new BusinessException("ids错误");
        }

        List<AttendClock> updateList = new ArrayList<>();
        String opName = null;
        AttendSchedulDetail schedulDetail = null;
        for (AttendClock attendClock : clockList) {
            if(attendClock.getClockStatus() != null && !DictConst.CLOCKSTATUS_1.equals(attendClock.getClockStatus())){
                schedulDetail = attendSchedulMapper.findById(attendClock.getSchedulDetailId());
                switch (attendClock.getClockStatus()){
                    //case DictConst.CLOCKSTATUS_2:
                    //    if(StringUtils.isEmpty(attendClock.getClockStart())) {
                    //        opName = "上班缺卡";
                    //        attendClock.setClockStart(schedulDetail.getStartTime());
                    //    }else{
                    //        opName = "下班缺卡";
                    //        attendClock.setClockEnd(schedulDetail.getEndTime());
                    //    }
                    //    break;
                    case DictConst.CLOCKSTATUS_21:
                        opName = "上班缺卡";
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        break;
                    case DictConst.CLOCKSTATUS_22:
                        opName = "下班缺卡";
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                        break;
                    case DictConst.CLOCKSTATUS_23:
                        opName = "下班缺卡，迟到";
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                        opName = opName +attendClock.getLateMin()+"分钟";
                        break;
                    case DictConst.CLOCKSTATUS_24:
                        opName = "上班缺卡，早退";
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                        opName = opName +attendClock.getLeaveEarly()+"分钟";
                        break;
                    case DictConst.CLOCKSTATUS_3:
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        opName = "迟到"+attendClock.getLateMin()+"分钟";
                        break;
                    case DictConst.CLOCKSTATUS_4:
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                        opName = "早退"+attendClock.getLeaveEarly()+"分钟";
                        break;
                    case DictConst.CLOCKSTATUS_34:
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        attendClock.setClockEnd(schedulDetail.getEndTime());
                        opName = "迟到"+attendClock.getLateMin()+"分钟,"+"早退"+attendClock.getLeaveEarly()+"分钟";
                        break;
                    case DictConst.CLOCKSTATUS_5:
                        attendClock.setClockStart(schedulDetail.getStartTime());
                        if(DictConst.SHIFTTYPE_JSBC.equals(attendClock.getShiftType())) {
                            attendClock.setClockEnd(schedulDetail.getEndTime());
                        }
                        opName = "漏卡";
                        break;
                    default:
                        break;
                }
                attendClock.setSchedulDetail(schedulDetail);
                attendClock.setClockStatus(DictConst.CLOCKSTATUS_1);
                attendClock.setUpdateBy(clockDetailDto.getCreateBy());
                attendClock.setUpdateTime(DateUtils.getNowDate());
                attendClock.setRemark("【" + clockDetailDto.getCreateName()+"】操作【"+opName+"】转【正常】");
                attendClock.setClockSource(DictConst.CLOCKSOURCE_SDBK);
                updateList.add(attendClock);
            }
        }
        if(updateList.size() == 0){
            throw new BusinessException("没有需要操作补卡的数据");
        }

        attendClockMapper.saveBatch(updateList);
        for (AttendClock attendClock : updateList) {
            // 更新统计结果
            if(DictConst.SHIFTTYPE_JCBC.equals(attendClock.getShiftType())){
                if (DateUtils.parseDate(attendClock.getSchedulDetail().getStartTime()).getTime() < DateUtils.getNowDate().getTime()) {
                    attendReportTask.createDayReport(attendClock.getSchedulDetail().getSchedulDate(), false, attendClock.getSchedulDetail().getPerId());
                    if (DateUtils.parseDate(attendClock.getSchedulDetail().getSchedulDate()).getTime() < DateUtils.getNowDate().getTime()) {
                        attendReportMapper.updateMonthReport(attendClock.getSchedulDetail());
                    }
                }
            }else {
                if (DateUtils.parseDate(attendClock.getSchedulDetail().getEndTime()).getTime() < DateUtils.getNowDate().getTime()) {
                    attendReportTask.createDayReport(attendClock.getSchedulDetail().getSchedulDate(), false, attendClock.getSchedulDetail().getPerId());
                    if (DateUtils.parseDate(attendClock.getSchedulDetail().getSchedulDate()).getTime() < DateUtils.getNowDate().getTime()) {
                        attendReportMapper.updateMonthReport(attendClock.getSchedulDetail());
                    }
                }
            }
        }

        return updateList.size();
    }

    @Override
    public List<MakeUpCardDto> getMissCard(AttendClockDto searchDto) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("unInClockStatus",new String[]{DictConst.CLOCKSTATUS_1});
        //上个月到这个月的
        paramMap.put("beginTime", DateUtils.parseDateToStr(DateUtils.YYYY_MM_DD,DateUtil.beginOfMonth(DateUtils.addMonths(DateUtils.getNowDate(),-1)).toJdkDate()));
        paramMap.put("endTime",DateUtils.getDate());
        searchDto.setParams(paramMap);
        List<AttendClockDto> clockDtoList = attendClockMapper.selectListForReport(searchDto);

        List<MakeUpCardDto> missCards = new ArrayList<>();
        if(clockDtoList.size() > 0) {
            paramMap.put("tlkPerId",clockDtoList.get(0).getTlkPerId());
            List<MakeUpCard> cardList = makeUpCardMapper.selectListForPer(paramMap);
            Map<Date,List<MakeUpCard>> cardsMap = cardList.stream().collect(Collectors.groupingBy(MakeUpCard::getStartTime));

            MakeUpCardDto makeUpCardDto = null;
            for (AttendClockDto attendClockDto : clockDtoList) {
                if (StrUtil.isEmpty(attendClockDto.getClockStart())
                ||(attendClockDto.getLateMin() != null && attendClockDto.getLateMin() > 0)) {
                    //TODO 排除已申请的补卡记录
                    boolean apply = false;
                    if(cardsMap.get(DateUtils.parseDate(attendClockDto.getStartTime())) != null){
                        List<MakeUpCard> subCards = cardsMap.get(DateUtils.parseDate(attendClockDto.getStartTime()));
                        for (MakeUpCard subCard : subCards) {
                            if(DictConst.CLOCKTYPE_SB.equals(subCard.getCardType())){
                                apply = true;
                            }
                        }
                    }

                    if(!apply) {
                        makeUpCardDto = new MakeUpCardDto();
                        makeUpCardDto.setCardTime(attendClockDto.getStartTime());
                        makeUpCardDto.setCardType(DictConst.CLOCKTYPE_SB);
                        missCards.add(makeUpCardDto);
                    }
                }
                if (StrUtil.isEmpty(attendClockDto.getClockEnd())
                || (attendClockDto.getLeaveEarly() != null && attendClockDto.getLeaveEarly() > 0)) {
                    if(DictConst.SHIFTTYPE_JCBC.equals(attendClockDto.getShiftType())){
                        continue;
                    }
                    //TODO 排除已申请的补卡记录
                    boolean apply = false;
                    if(cardsMap.get(DateUtils.parseDate(attendClockDto.getEndTime())) != null){
                        List<MakeUpCard> subCards = cardsMap.get(DateUtils.parseDate(attendClockDto.getEndTime()));
                        for (MakeUpCard subCard : subCards) {
                            if(DictConst.CLOCKTYPE_XB.equals(subCard.getCardType())){
                                apply = true;
                            }
                        }
                    }

                    if(!apply) {
                        makeUpCardDto = new MakeUpCardDto();
                        makeUpCardDto.setCardTime(attendClockDto.getEndTime());
                        makeUpCardDto.setCardType(DictConst.CLOCKTYPE_XB);
                        missCards.add(makeUpCardDto);
                    }
                }
            }

            missCards = missCards.stream().sorted(Comparator.comparing(MakeUpCardDto::getCardTime)).collect(Collectors.toList());
        }

        return missCards;
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.beginOfMonth(DateUtils.addMonths(DateUtils.getNowDate(),-1)));
    }
}
