package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendClockDetail;
import com.bcxin.platform.mapper.attend.AttendClockDetailMapper;
import com.bcxin.platform.service.attend.AttendClockDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 考勤打卡记录Service业务层处理
 * 
 * @author lin
 * @date 2021-08-27
 */
@Service
@Transactional("transactionManager")
public class AttendClockDetailServiceImpl implements AttendClockDetailService{

    @Autowired
    private AttendClockDetailMapper attendClockDetailMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    @Override
    public AttendClockDetail findById(Long id){
        return attendClockDetailMapper.findById(id);
    }

    /**
     * 修改考勤打卡记录
     * 
     * @param attendClockDetail 考勤打卡记录
     * @return 结果
     */
    @Override
    public int update(AttendClockDetail attendClockDetail){
        if(attendClockDetail.getId() == null){
            attendClockDetail.setCreateTime(DateUtils.getNowDate());
            attendClockDetail.setId(idWorker.nextId());
        }else{
            AttendClockDetail dbAttendClockDetail = attendClockDetailMapper.findById(attendClockDetail.getId());
            BeanUtils.copyPropertiesIgnore(attendClockDetail,dbAttendClockDetail,true);
            BeanUtils.copyPropertiesIgnore(dbAttendClockDetail,attendClockDetail,false);
        }
        attendClockDetail.setUpdateTime(DateUtils.getNowDate());
        return attendClockDetailMapper.save(attendClockDetail);
    }

    /**
     * 删除考勤打卡记录对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendClockDetailMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤打卡记录信息
     * 
     * @param id 考勤打卡记录ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendClockDetailMapper.deleteById(id);
    }
}
