package com.bcxin.platform.service.attend.impl;

import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.core.text.Convert;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendCalendar;
import com.bcxin.platform.domain.company.PerOrgRelation;
import com.bcxin.platform.mapper.attend.AttendCalendarMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestDetailMapper;
import com.bcxin.platform.mapper.attend.AttendCalendarRestMapper;
import com.bcxin.platform.mapper.company.PerOrgRelationMapper;
import com.bcxin.platform.service.attend.AttendCalendarService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 考勤打卡日历套Service业务层处理
 * 
 * @author lin
 * @date 2021-08-10
 */
@Service
@Transactional("transactionManager")
public class AttendCalendarServiceImpl implements AttendCalendarService{

    @Autowired
    private AttendCalendarMapper attendCalendarMapper;

    @Autowired
    private AttendCalendarRestMapper attendCalendarRestMapper;

    @Autowired
    private AttendCalendarRestDetailMapper attendCalendarRestDetailMapper;

    @Autowired
    private PerOrgRelationMapper perOrgRelationMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤打卡日历套
     * 
     * @param id 考勤打卡日历套ID
     * @return 考勤打卡日历套
     */
    @Override
    public AttendCalendar findById(Long id){
        return attendCalendarMapper.findById(id);
    }

    /**
     * 查询考勤打卡日历套列表
     * 
     * @param searchDto 考勤打卡日历套
     * @return 考勤打卡日历套
     */
    @Override
    public List<AttendCalendar> selectList(AttendCalendar searchDto){
        //加上数据权限
        if(!searchDto.isDomainAdmin() && (searchDto.getAdminDepartIds()== null || searchDto.getAdminDepartIds().size() == 0)){
            return new ArrayList<>();
        }
        return attendCalendarMapper.selectList(searchDto);
    }

    /**
     * 修改考勤打卡日历套
     * 
     * @param attendCalendar 考勤打卡日历套
     * @return 结果
     */
    @Override
    public int update(AttendCalendar attendCalendar){

        AttendCalendar dbAttendCalendar = attendCalendarMapper.findByName(attendCalendar.getCalendarName());
        if(dbAttendCalendar != null && !dbAttendCalendar.getId().equals(attendCalendar.getId())){
            throw new BusinessException("日历套名称已存在！");
        }

        if(attendCalendar.getId() == null){
            attendCalendar.setCreateTime(DateUtils.getNowDate());
            attendCalendar.setId(idWorker.nextId());
            attendCalendar.setIsDelete(Constants.N);

//            PerOrgRelation relation = perOrgRelationMapper.findByPerId(Long.parseLong(attendCalendar.getCreateBy()));
//            attendCalendar.setDeptId(relation.getOrgId());

        }else{
            dbAttendCalendar = attendCalendarMapper.findById(attendCalendar.getId());
            BeanUtils.copyPropertiesIgnore(attendCalendar,dbAttendCalendar,true);
            BeanUtils.copyPropertiesIgnore(dbAttendCalendar,attendCalendar,false);
        }
        attendCalendar.setUpdateTime(DateUtils.getNowDate());
        return attendCalendarMapper.save(attendCalendar);
    }

    /**
     * 删除考勤打卡日历套对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        //TODO 判断日历套是否已被使用，如果被使用则不能删除

        attendCalendarRestMapper.deleteByCalendarIds(Convert.toStrArray(ids));
        attendCalendarRestDetailMapper.deleteByCalendarIds(Convert.toStrArray(ids));
        return attendCalendarMapper.deleteByIds(Convert.toStrArray(ids));
    }

}
