package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.dto.wallet.ComSubsidyGrantEvent;
import com.bcxin.platform.dto.wallet.ComWalletTransferDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业补贴发放事件
 *
 * @author llc
 * @date 2020-10-16
 */
public interface ComSubsidyGrantEventMapper {

    /**
     * 插入企业补贴发放事件
     *
     * @param comSubsidyGrantEvent
     * @return
     * @author llc
     * @date 2020-10-16
     */
    int insertComSubsidyGrantEvent(ComSubsidyGrantEvent comSubsidyGrantEvent);


    /**
     * 查询企业补贴发放事件
     *
     * @param comSubsidyGrantId
     * @return
     * @author llc
     * @date 2020-10-16
     */
    ComSubsidyGrantEvent getComSubsidyGrantEvent(@Param("comSubsidyGrantId") Long comSubsidyGrantId);


    /**
     * 查询企业已发放补贴列表
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-10-16
     */
    List<Map<String, Object>> getYffSubsidyList(ComWalletTransferDTO dto);


    /**
     * 查询已发放补贴统计信息
     *
     * @param dto
     * @return
     * @author llc
     * @date 2020-10-16
     */
    Map<String, Object> getYffSubsidyInfo(ComWalletTransferDTO dto);


}