package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.ComBhGrantDetail;
import com.bcxin.platform.dto.grant.ComBhGrantInfoDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 企业渤海薪资发放明细
 *
 * @author llc
 * @date 2020-08-14
 */
public interface ComBhGrantDetailMapper {

    /**
     * 获取渤海薪资发放明细详情
     * @param comBhGrantDetailId
     * @author llc
     * @date 2020-08-17
     */
    ComBhGrantDetail getComBhGrantDetailById(@Param("comBhGrantDetailId") Long comBhGrantDetailId);

    /**
     * 删除渤海薪资发放明细
     * @param comBhGrantDetailId
     * @author llc
     * @date 2020-08-17
     */
    int deleteById(@Param("comBhGrantDetailId") Long comBhGrantDetailId);

    /**
     * 删除渤海薪资发放明细
     * @param comBhGrantId
     * @author llc
     * @date 2020-08-14
     */
    int deleteByComBhGrantId(@Param("comBhGrantId") Long comBhGrantId);

    /**
     * 查询渤海薪资发放明细列表
     * @param dto
     * @author llc
     * @date 2020-08-14
     */
    List<Map<String, Object>> getComBhGrantDetailList(ComBhGrantInfoDTO dto);


    /**
     * 线下渤海代发导入-插入待发放信息
     *
     * @param importBatchId
     * @param createBy
     * @param comBhGrantId
     * @param grantYears
     * @author llc
     * @date 2020-08-17
     */
    Integer insertBhGrantDetail(@Param("importBatchId") Long importBatchId,
                                @Param("createBy") Long createBy,
                                @Param("comBhGrantId") Long comBhGrantId,
                                @Param("grantYears") String grantYears);


    /**
     * 线下渤海代发导入-插入银行卡待发放信息
     *
     * @param importBatchId
     * @param createBy
     * @param comBhGrantId
     * @param grantYears
     * @author llc
     * @date 2020-12-04
     */
    Integer insertBhBankGrantDetail(@Param("importBatchId") Long importBatchId,
                                    @Param("createBy") Long createBy,
                                    @Param("comBhGrantId") Long comBhGrantId,
                                    @Param("grantYears") String grantYears);


    /**
     * 更新代发结果失败信息
     *
     * @param updateBy
     * @param comBhGrantId
     * @param list
     * @author llc
     * @date 2020-09-21
     */
    Integer updateBhGrantFailDetail(@Param("updateBy") Long updateBy,
                                    @Param("comBhGrantId") Long comBhGrantId,
                                    @Param("list") List<Map> list);


    /**
     * 更新代发结果成功信息
     *
     * @param updateBy
     * @param comBhGrantId
     * @param list
     * @author llc
     * @date 2020-09-21
     */
    Integer updateBhGrantSuccessDetail(@Param("updateBy") Long updateBy,
                                       @Param("comBhGrantId") Long comBhGrantId,
                                       @Param("list") List<Map> list);
}