package com.bcxin.platform.mapper.attend;

import com.bcxin.oaflow.domain.OaBusinessBaseEntity;
import com.bcxin.platform.domain.attend.AttendReport;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.dto.app.AppAttendReportDto;
import com.bcxin.platform.dto.app.AppAttendSearchDto;
import com.bcxin.platform.dto.attend.AttendReportDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤结果统计Mapper接口
 * 
 * @author lin
 * @date 2021-08-30
 */
public interface AttendReportMapper{

    /**
     * 查询考勤结果统计
     * 
     * @param id 考勤结果统计ID
     * @return 考勤结果统计
     */
    AttendReport findById(Long id);

    /**
     *  查询考勤结果详情
     * @param id
     * @return
     */
    AttendReportDto findDetail(Long id);

    /**
     * 查询考勤结果统计列表
     * 
     * @param attendReport 考勤结果统计
     * @return 考勤结果统计集合
     */
    List<AttendReportDto> selectList(AttendReportDto attendReport);

    /**
     * 删除考勤结果统计
     * 
     * @param id 考勤结果统计ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤结果统计
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendReport
     * @return
     */
    int save(AttendReport attendReport);

    /****
     * 选择修改
     * @param attendReport
     * @return
     */
    int updateSelective(AttendReport attendReport);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendReport> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendReport> findByBatchId(@Param("list") List<AttendReport> list);

    List<AttendReport> selectListForStatistics(@Param("list")List<String> tlkPerIds,@Param("reportDate") String reportDate);

    List<AttendReport> selectListForReport(@Param("list")List<String> tlkPerIds,@Param("reportDate") String reportDate);

    void createMonthReport(@Param("reportDate") String reportDate,@Param("perId")Long perId,@Param("days") int days);

    void removeMonthReport(@Param("reportDate") String reportDate,@Param("perId")Long perId);

    AppAttendReportDto findMonthReport(AppAttendSearchDto searchDto);

    AppAttendReportDto findMonthStatistics(AppAttendSearchDto searchDto);

    List<AppAttendReportDto> findDayStatistics(AppAttendSearchDto searchDto);

    List<AttendReport> selectListForOA(OaBusinessBaseEntity oaBusiness);

    void updateDayReport(OaBusinessBaseEntity oaBusiness);

    AttendReport findByPerId(@Param("perId") Long perId, @Param("reportDate") String reportDate);

    void updateMonthReportForOA(OaBusinessBaseEntity oaBusiness);

    void updateMonthReport(AttendSchedulDetail schedulDetail);
}
