package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendCharge;
import com.bcxin.platform.domain.company.PerBaseInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤套负责人Mapper接口
 * 
 * @author lin
 * @date 2021-09-30
 */
public interface AttendChargeMapper{

    /**
     * 查询考勤套负责人
     * 
     * @param id 考勤套负责人ID
     * @return 考勤套负责人
     */
    AttendCharge findById(Long id);

    /**
     * 查询考勤套负责人列表
     * 
     * @param attendCharge 考勤套负责人
     * @return 考勤套负责人集合
     */
    List<AttendCharge> selectList(AttendCharge attendCharge);

    /**
     * 删除考勤套负责人
     * 
     * @param id 考勤套负责人ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤套负责人
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendCharge
     * @return
     */
    int save(AttendCharge attendCharge);

    /****
     * 选择修改
     * @param attendCharge
     * @return
     */
    int updateSelective(AttendCharge attendCharge);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendCharge> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendCharge> findByBatchId(@Param("list") List<AttendCharge> list);

    /**
     * 根据考勤套id查询负责人
     * @param attendId
     * @return
     */
    List<AttendCharge> findByAttendId(Long attendId);

    List<PerBaseInfo> findPerByAttendId(Long attendId);
}
