package com.bcxin.platform.dto.wallet;

import com.bcxin.platform.util.BaseEntity;
import lombok.Data;

/**
 * 商户转账
 *
 * @author lp
 * @date 2019-08-27
 */
@Data
public class ComWalletTransferDTO extends BaseEntity<ComWalletTransferDTO> {

    /**
     * 出账方
     */
    private String outId;

    /**
     * 入账方
     */
    private String inId;

    /**
     * 业务交易流水号
     */
    private String businessPartnerSeq;
    /**
     * 业务编码
     */
    private String businessCode;

    /* 订单金额 */
    private String amount;

    /* 是否需要验证码 */
    private String needActiveCode;

    /* 验证码 */
    private String activeCode;

    /* 手机号*/
    private String mobilePhone;

    /* 备注*/
    private String comment;

    /*** 划账金额 ***/
    private String lastschriftAmount;

    /*** 批次号 ***/
    private String batchNo;

    /*** 批次名称 ***/
    private String batchName;

    /*** 补贴类型 ***/
    private String subsidyType;

    /*** 补贴对象 ***/
    private String subsidyObject;


    /*** 开始时间 ***/
    private String startTime;

    /*** 结束时间 ***/
    private String endTime;

    /*** 商品名称 ***/
    private String goodsName;
    /*** 商品数量 ***/
    private String goodsNumber;
    /*** 商品单位 ***/
    private String goodsUnit;
    /*** 交易类型：04冻结，05解冻 ***/
    private String tradeType;

}