package com.bcxin.platform.dto.order;

import com.bcxin.platform.domain.order.ComOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 企业订单支付dto
 * 
 * @author llc
 * @date 2020-01-15
 */
@Data
public class ComOrderPayDTO extends ComOrder {

	/** 收入企业ID */
	@ApiModelProperty(value = "收入企业ID")
	private Long inComId;

	/** 交易说明 */
	@ApiModelProperty(value = "交易说明")
	private String comment;

	/** 手机验证码 */
	@ApiModelProperty(value = "手机验证码")
	private String activeCode;

	@JsonSerialize(using = ToStringSerializer.class)
	public Long getInComId() {
		return inComId;
	}
}