package com.bcxin.platform.dto.insurance;


import lombok.Data;

/**
 * <b>企业信息表 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:16:48
 * @注意事项 </b>
 * <b>
 */
@Data
public class BLBComInfoDTO {

	/**
	 * roleInpolicyID投保人/被保人id
	 */
	private String oid;
	/**
	 * 投保人类型
	 */
	private String role_type;
	/**
	 * 投保人角色
	 */
	private String kind;
	/**
	 * 投保人/被保险人名称(中文)
	 */
	private String name_cn;
	/**
	 * 投保人/被保险人名称(英文)
	 */
	private String name_en;
	/**
	 * 证件类型
	 */
	private String id_type;

	/**
	 * 地址-具体通讯地址
	 */
	private String address;

	/**
	 * 固定电话
	 */
	private String phone;

	/**
	 * 固定电话
	 */
	private String tel;

	/**
	 * 电子邮箱
	 */
	private String email;

	/**
	 * 受益人信息
	 */
//	private List<InsRoleFavoree> insRoleFavoreeList;

	/**********************企业信息*************************/

	/**
	 * 成立日期
	 */
	private String register_date;
	/**
	 * 注册地址 省
	 */
	private String reg_province;
	/**
	 * 注册地址 市
	 */
	private String reg_city;
	/**
	 * 注册地址 区
	 */
	private String reg_district;
	/**
	 * 注册地址
	 */
	private String reg_address;
	/**
	 * 营业地址
	 */
	private String do_business_address;
	/**
	 * 地区
	 */
	private String region;
	/**
	 * 组织机构代码
	 */
	private String organization_code;
	/**
	 * 税务登记证
	 */
	private String tax_code;
	/**
	 * 工商注册号/企业注册号
	 */
	private String aaum_code;
	/**
	 * 海关统计经营单位编码
	 */
	private String customs_code;
	/**
	 * 企业类型/性质
	 */
	private String com_type;
	/**
	 * 投保业务类别
	 */
	private String business_nature;
	/**
	 * 买方所属行业
	 */
	private String sectors_sold;
	/**
	 * 经营区域
	 */
	private String business_area;
	/**
	 * 证件有效期起始
	 */
	private String id_option;
	/**
	 * 证件有效期起期
	 */
	private String id_star_date;
	/**
	 * 证件有效期止期
	 */
	private String id_end_date;
	/**
	 * 联系部门
	 */
	private String link_section;
	/**
	 * 投保人关联企业信息
	 */
	private String companies_detail;
	/**
	 * 是否已有信用险保单
	 */
	private int id_insurance;
	/**
	 * 保险公司名称
	 */
	private String insurance_name;
	/**
	 * 预计未来12个月的投保内贸营业额
	 */
	private String turnover_domestic;
	/**
	 * 预计未来12个月的投保出口营业额
	 */
	private String turnover_export;
	/**
	 * 投保币种
	 */
	private String currency_required;
	/**
	 * 经营性质
	 */
	private String com_nature;
	/**
	 * 经营性质(营业性质2级)
	 */
	private String nature_two;
	/**
	 * 所属行业
	 */
	private String industry;
	/**
	 * 其他行业
	 */
	private String other_industry;
	/**
	 * 法人姓名
	 */
	private String legal_name;
	/**
	 * 法人职务
	 */
	private String legal_duty;
	/**
	 * 法人电话
	 */
	private String legal_phone;
	/**
	 * 委托代理人姓名
	 */
	private String agent_name;
	/**
	 * 委托代理人职务
	 */
	private String agent_duty;
	/**
	 * 委托代理人电话
	 */
	private String agent_phone;
	/**
	 * 委托代理人电子信箱
	 */
	private String agent_email;
	/**
	 * 联系人姓名
	 */
	private String link_name;
	/**
	 * 联系人职务
	 */
	private String link_duty;
	/**
	 * 联系人传真
	 */
	private String link_fax;
	/**
	 * 联系人电话
	 */
	private String link_phone;
	/**
	 * 联系人手机
	 */
	private String link_tel;
	/**
	 * 联系人电子信箱
	 */
	private String link_email;

	/**邮编*/
	private String zip_code;

	/**
	 * 申请人／原告主体资格
	 */
	private String right_as_principal;

	/**
	 * 企业总人数
	 */
	private String total_emp;


	/**********************个人信息*************************/

	/**
	 * 国籍
	 */
	private String nationality;

	/**
	 * 证件号码
	 */
	private String id_no;
	/**
	 * 证件有效期结束日期
	 */
	private String validity_end;
	/**
	 * 性别
	 */
	private String sex;
	/**
	 * 出生日期
	 */
	private String birth_date;
	/**
	 * 职业类别"内勤人员-1", "保安人员-2","武装押运人员-3"
	 */
	private String major_group;
	/**
	 * 身高
	 */
	private String stature;
	/**
	 * 体重
	 */
	private String weight;
	/**
	 * 年收入
	 */
	private String annual_income;
	/**
	 * 累计保额
	 */
	private String coverage_sum;
	/**
	 * 手机号
	 */
	private String mobile;

	/**
	 * 地址-省
	 */
	private String province;
	/**
	 * 地址-市
	 */
	private String city;
	/**
	 * 地址-区/县
	 */
	private String area_code;

	/**
	 * 身份证复印件
	 */
	private  String app_idcard_path;
	/**
	 * 常住地证明文件复印件
	 */
	private String app_address_path;

	/**
	 * 配偶身份证复印件
	 */
	private String app_spouse_card_path;

	/**
	 * 结婚证复印件
	 */
	private String app_trauschein_path;

	/**
	 * 营业执照复印件
	 */
	private String app_business_path;

	/**
	 * 组织机构代码证
	 */
	private String app_organizing_path;

	/**
	 * 税务登记证
	 */
	private String app_tax_path;
	private String project_name;
	private String project_address;
	private String project_start_time;
	private String project_end_time;

}