package com.bcxin.platform.dto.excel;

import com.bcxin.platform.util.excel.ExcelVOAttribute;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class InsExcelVo implements Serializable {

	@ExcelVOAttribute(name = "所属区域", column = "A", isExport = true, isRequest = false)
	private String area;

	@ExcelVOAttribute(name = "公司名称", column = "B", isExport = true, isRequest = false)
	private String comName;

	@ExcelVOAttribute(name = "保险起期", column = "C", isExport = true, isRequest = false)
	private String effectStartDate;

	@ExcelVOAttribute(name = "保险止期", column = "D", isExport = true, isRequest = false)
	private String effectEndDate;

	@ExcelVOAttribute(name = "企业SAAS人数", column = "E", isExport = true, isRequest = false)
	private String zzNum;

	@ExcelVOAttribute(name = "企业SAAS认证数", column = "F", isExport = true, isRequest = false)
	private String rzNum;

	@ExcelVOAttribute(name = "在保人数", column = "G", isExport = true, isRequest = false)
	private String zbNum;

	@ExcelVOAttribute(name = "购买方式", column = "H", isExport = true, isRequest = false)
	private String buyMode;

	@ExcelVOAttribute(name = "保险公司", column = "I", isExport = true, isRequest = false)
	private String insComName;

	@ExcelVOAttribute(name = "保险产品名称", column = "J", isExport = true, isRequest = false)
	private String productName;

	@ExcelVOAttribute(name = "每人保费", column = "K", isExport = true, isRequest = false)
	private String perPremiums;

	@ExcelVOAttribute(name = "保单号", column = "L", isExport = true, isRequest = false)
	private String policyNo;

	/**
	 * 导入的错误信息
	 */
	private String errorMsg;

	public InsExcelVo(){}

	public InsExcelVo(String area
			, String comName
			, String effectStartDate
			, String effectEndDate
			, String zzNum
			, String rzNum
			, String zbNum, String buyMode, String insComName, String productName, String perPremiums, String policyNo){
		this.area = area;
		this.comName = comName;
		this.effectStartDate = effectStartDate;
		this.effectEndDate = effectEndDate;
		this.zzNum = zzNum;
		this.rzNum = rzNum;
		this.zbNum = zbNum;
		this.buyMode = buyMode;
		this.insComName = insComName;
		this.productName = productName;
		this.perPremiums = perPremiums;
		this.policyNo = policyNo;
	}

	public String getArea() {
		return area;
	}

	public void setArea(String area) {
		this.area = area;
	}

	public String getComName() {
		return comName;
	}

	public void setComName(String comName) {
		this.comName = comName;
	}

	public String getEffectStartDate() {
		return effectStartDate;
	}

	public void setEffectStartDate(String effectStartDate) {
		this.effectStartDate = effectStartDate;
	}

	public String getEffectEndDate() {
		return effectEndDate;
	}

	public void setEffectEndDate(String effectEndDate) {
		this.effectEndDate = effectEndDate;
	}

	public String getZzNum() {
		return zzNum;
	}

	public void setZzNum(String zzNum) {
		this.zzNum = zzNum;
	}

	public String getRzNum() {
		return rzNum;
	}

	public void setRzNum(String rzNum) {
		this.rzNum = rzNum;
	}

	public String getZbNum() {
		return zbNum;
	}

	public void setZbNum(String zbNum) {
		this.zbNum = zbNum;
	}

	public String getBuyMode() {
		return buyMode;
	}

	public void setBuyMode(String buyMode) {
		this.buyMode = buyMode;
	}

	public String getInsComName() {
		return insComName;
	}

	public void setInsComName(String insComName) {
		this.insComName = insComName;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getPerPremiums() {
		return perPremiums;
	}

	public void setPerPremiums(String perPremiums) {
		this.perPremiums = perPremiums;
	}

	public String getPolicyNo() {
		return policyNo;
	}

	public void setPolicyNo(String policyNo) {
		this.policyNo = policyNo;
	}

	public String getErrorMsg() {
		if (StringUtils.isNotEmpty(errorMsg)) {
			return errorMsg;
		} else {
			return "";
		}
	}

	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}
}
