package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.AddGroup;
import com.bcxin.platform.common.utils.validator.group.FactorGroup;
import com.bcxin.platform.common.utils.validator.group.UpdateGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/12 0012 13:20
 */
@Data
public class AttendSchedulDto extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="考勤套不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long attendId;

    /** 日历套ID */
    @Excel(name = "日历套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long calendarId;

    /** 是否使用休息日套 1是0否 */
    @Excel(name = "是否使用休息日套 1是0否")
    @NotBlank(message="是否使用休息日套不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String needCalendar;

    @NotEmpty(message="人员不能为空", groups = {AddGroup.class, UpdateGroup.class})
    String[] perIds;

    @NotEmpty(message="班次不能为空", groups = {AddGroup.class, UpdateGroup.class})
    String[] shiftIds;

    /** 开始日期 */
    @Excel(name = "开始日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotBlank(message="开始日期不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String startDate;

    /** 结束日期 */
    @Excel(name = "结束日期", width = 30, dateFormat = "yyyy-MM-dd")
    @NotBlank(message="结束日期不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private String endDate;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @NotNull(message="公司不能为空", groups = {AddGroup.class, UpdateGroup.class})
    private Long comId;

    private boolean removeOld = false;

    @NotEmpty(message="星期不能为空", groups = {FactorGroup.class})
    private List<Integer> weeks;
}
